/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.event;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import org.icefaces.impl.application.WindowScopeManager;
import org.icefaces.impl.event.BridgeSetup;
import org.icefaces.impl.event.UIOutputWriter;
import org.icefaces.util.EnvUtils;

public class WindowAndViewIDSetup
implements SystemEventListener {
    private static final Logger Log = Logger.getLogger(WindowAndViewIDSetup.class.getName());
    private static final String ID_SUFFIX = "_windowviewid";
    private boolean partialStateSaving = EnvUtils.isPartialStateSaving(FacesContext.getCurrentInstance());

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        FacesContext context = FacesContext.getCurrentInstance();
        if (!EnvUtils.isICEfacesView(context)) {
            return;
        }
        HtmlForm form = (HtmlForm)((PostAddToViewEvent)event).getComponent();
        String componentId = form.getId() + ID_SUFFIX;
        if (!this.partialStateSaving) {
            for (UIComponent child : form.getChildren()) {
                String id = child.getId();
                if (null == id || !id.endsWith(ID_SUFFIX)) continue;
                return;
            }
        }
        if (null != context.getAttributes().get(componentId)) {
            return;
        }
        context.getAttributes().put(componentId, componentId);
        UIOutputWriter output = new UIOutputWriter(){

            public void encode(ResponseWriter writer, FacesContext context) throws IOException {
                Map requestMap = context.getExternalContext().getRequestMap();
                if (WindowScopeManager.lookupAssociatedWindowID(requestMap) == null) {
                    Log.severe("Missing window ID attribute. Request map cleared prematurely.");
                    return;
                }
                String viewId = BridgeSetup.getViewID(context.getExternalContext());
                if (viewId == null) {
                    Log.severe("Missing view ID attribute. Request map cleared prematurely.");
                    return;
                }
                writer.startElement("input", (UIComponent)this);
                writer.writeAttribute("type", (Object)"hidden", null);
                writer.writeAttribute("name", (Object)"ice.window", null);
                writer.writeAttribute("value", (Object)WindowScopeManager.lookupWindowScope(context).getId(), null);
                writer.endElement("input");
                writer.startElement("input", (UIComponent)this);
                writer.writeAttribute("type", (Object)"hidden", null);
                writer.writeAttribute("name", (Object)"ice.view", null);
                writer.writeAttribute("value", (Object)viewId, null);
                writer.endElement("input");
            }
        };
        output.setTransient(true);
        output.setId(componentId);
        form.getChildren().add(0, output);
    }

    public boolean isListenerForSource(Object source) {
        return source instanceof HtmlForm;
    }
}

