/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.clinicalpipeline.runtime;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import org.apache.ctakes.core.util.DocumentIDAnnotationUtil;
import org.apache.uima.UIMAException;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.factory.CollectionReaderFactory;
import org.apache.uima.fit.pipeline.JCasIterator;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

public abstract class BagOfAnnotationsGenerator<T extends Annotation, K> {
    private String outputDir = null;
    private CollectionReader reader = null;
    private AnalysisEngine ae = null;
    private static final String defaultAEPath = "desc/analysis_engine/AggregatePlaintextUMLSProcessor.xml";
    private Class<T> classOfT;

    public BagOfAnnotationsGenerator(String inputDir, String outputDir) throws UIMAException, IOException {
        this(inputDir, outputDir, null);
    }

    public BagOfAnnotationsGenerator(String inputDir, String outputDir, String aePath) throws UIMAException, IOException {
        this.reader = CollectionReaderFactory.createReaderFromPath((String)"../ctakes-core/desc/collection_reader/FilesInDirectoryCollectionReader.xml", (Object[])new Object[]{"InputDirectory", inputDir});
        this.ae = AnalysisEngineFactory.createEngineFromPath((String)(aePath == null ? defaultAEPath : aePath), (Object[])new Object[0]);
        this.outputDir = outputDir;
        this.classOfT = this.getClassOfT();
    }

    public void process() throws UIMAException, IOException {
        JCasIterator casIter = new JCasIterator(this.reader, new AnalysisEngine[]{this.ae});
        while (casIter.hasNext()) {
            JCas jcas = casIter.next();
            String docId = DocumentIDAnnotationUtil.getDocumentID((JCas)jcas);
            this.processCas(jcas, this.outputDir + File.separator + docId);
        }
        this.ae.destroy();
    }

    private void processCas(JCas jcas, String outputFilename) throws FileNotFoundException {
        PrintStream out = new PrintStream(outputFilename);
        Collection annotations = JCasUtil.select((JCas)jcas, this.classOfT);
        for (Annotation annot : annotations) {
            K output = this.extractInformation(annot);
            if (output == null) continue;
            out.println(output);
        }
        out.close();
    }

    protected abstract K extractInformation(T var1);

    private Class<T> getClassOfT() {
        ParameterizedType superclass = (ParameterizedType)this.getClass().getGenericSuperclass();
        return (Class)superclass.getActualTypeArguments()[0];
    }
}

