/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.coreference.ae.features.cluster;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.ctakes.core.util.ListIterable;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.typesystem.type.relation.CollectionTextRelation;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.Markable;
import org.apache.ctakes.typesystem.type.textspan.Paragraph;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.cleartk.ml.Feature;
import org.cleartk.ml.feature.extractor.CleartkExtractorException;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;

public class MentionClusterSectionFeaturesExtractor
implements RelationFeaturesExtractor<CollectionTextRelation, IdentifiedAnnotation>,
FeatureExtractor1<Markable> {
    public List<Feature> extract(JCas jcas, CollectionTextRelation cluster, IdentifiedAnnotation mention) throws AnalysisEngineProcessException {
        ArrayList<Feature> feats = new ArrayList<Feature>();
        HashSet<Integer> parsWithAnteHeader = new HashSet<Integer>();
        boolean anteInHeader = false;
        int anaPar = -1;
        ArrayList pars = new ArrayList(JCasUtil.select((JCas)jcas, Paragraph.class));
        block0: for (int i = 0; i < pars.size(); ++i) {
            Paragraph par = (Paragraph)pars.get(i);
            if (mention.getBegin() >= par.getBegin() && mention.getEnd() <= par.getEnd()) {
                anaPar = i;
            }
            if (par.getBegin() > mention.getEnd()) break;
            List coveredSents = JCasUtil.selectCovered(Sentence.class, (AnnotationFS)par);
            if (coveredSents == null || coveredSents.size() == 0 || coveredSents.size() > 1) continue;
            for (Markable member : new ListIterable(cluster.getMembers())) {
                if (member.getBegin() < par.getBegin() || member.getEnd() > par.getEnd()) continue;
                parsWithAnteHeader.add(i);
                anteInHeader = true;
                continue block0;
            }
        }
        feats.add(new Feature("AnteInHeader", (Object)(parsWithAnteHeader.size() > 0 ? 1 : 0)));
        if (anteInHeader && parsWithAnteHeader.contains(anaPar - 1)) {
            feats.add(new Feature("AnteHeaderHeadsAna", (Object)true));
        }
        return feats;
    }

    public List<Feature> extract(JCas jcas, Markable mention) throws CleartkExtractorException {
        Paragraph par;
        ArrayList<Feature> feats = new ArrayList<Feature>();
        boolean anaInHeader = false;
        int anaPar = -1;
        ArrayList pars = new ArrayList(JCasUtil.select((JCas)jcas, Paragraph.class));
        for (int i = 0; i < pars.size() && (par = (Paragraph)pars.get(i)).getBegin() <= mention.getEnd(); ++i) {
            List coveredSents;
            if (mention.getBegin() >= par.getBegin() && mention.getEnd() <= par.getEnd()) {
                anaPar = i;
            }
            if ((coveredSents = JCasUtil.selectCovered((JCas)jcas, Sentence.class, (AnnotationFS)par)) == null || coveredSents.size() != 1 || anaPar != i) continue;
            anaInHeader = true;
            break;
        }
        feats.add(new Feature("AnaInHeader", (Object)anaInHeader));
        return feats;
    }
}

