/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.coreference.treekernel.training;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.Scanner;

public class KernelMatrixCompositor {
    public static void main(String[] args) {
        if (args.length < 4) {
            System.err.println("Usage: KernelMatrixCompositor <numExamples> <Matrix 1 file> <Matrix 1 multiplier> <Matrix 2 file> <Matrix 2 multiplier ... <Matrix N file> <Matrix N multipler> <Matrix output>");
            System.exit(1);
        }
        PrintWriter out = null;
        try {
            out = new PrintWriter(args[args.length - 1]);
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
            System.err.println("Unable to open output file... exiting!");
            System.exit(1);
        }
        int dim = Integer.parseInt(args[0]);
        double[][] matrix = new double[dim][dim];
        int[] labels = new int[dim];
        Scanner scanner = null;
        for (int argnum = 1; argnum < args.length - 1; argnum += 2) {
            System.out.println("Reading file... " + args[argnum] + " with weight... " + args[argnum + 1]);
            try {
                scanner = new Scanner(new File(args[argnum]));
                double multiplier = Double.parseDouble(args[argnum + 1]);
                int lineNum = 0;
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine();
                    String[] parts = line.trim().split(" ");
                    if (argnum == 1) {
                        labels[lineNum] = Integer.parseInt(parts[0]);
                    }
                    int i = lineNum;
                    for (int j = 2; j < parts.length; ++j) {
                        String[] node = parts[j].split(":");
                        double[] dArray = matrix[i];
                        int n = j - 2;
                        dArray[n] = dArray[n] + multiplier * Double.parseDouble(node[1]);
                    }
                    ++lineNum;
                }
                continue;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        System.out.println("Printing out composite matrix...");
        for (int i = 0; i < dim; ++i) {
            out.print(labels[i]);
            out.print(" 0:");
            out.print(i + 1);
            for (int j = 0; j < dim; ++j) {
                out.print(" ");
                out.print(j + 1);
                out.print(":");
                out.print(matrix[i][j]);
            }
            out.println();
        }
        out.close();
        System.out.println("Done!");
    }
}

