/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.coreference.util;

import java.util.ArrayList;
import java.util.LinkedList;
import org.apache.ctakes.coreference.type.Markable;
import org.apache.ctakes.coreference.util.AttributeCalculator;
import org.apache.ctakes.coreference.util.FSIteratorToList;
import org.apache.ctakes.coreference.util.MarkableTreeUtils;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.syntax.TerminalTreebankNode;
import org.apache.ctakes.typesystem.type.syntax.TreebankNode;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textspan.LookupWindowAnnotation;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

public class AnaphoricityAttributeCalculator
extends AttributeCalculator {
    private Markable m;
    String s;
    String pos;

    public AnaphoricityAttributeCalculator(JCas jcas, Markable m) {
        super(jcas);
        this.m = m;
        this.s = m.getCoveredText();
        this.pos = this.getPOS();
    }

    private String getPOS() {
        try {
            TreebankNode node = MarkableTreeUtils.markableNode(this.jcas, this.m.getBegin(), this.m.getEnd());
            TerminalTreebankNode wordNode = MarkableTreeUtils.getHead(node);
            return wordNode.getNodeType();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String calcmDefinite() {
        return AnaphoricityAttributeCalculator.isDefinite(this.s) ? "Y" : "N";
    }

    public String calcmDemonstrative() {
        return AnaphoricityAttributeCalculator.isDemonstrative(this.s) ? "Y" : "N";
    }

    public String calcmNumSing() {
        if (this.pos == null) {
            return "N";
        }
        if (this.pos.equals("NN") || this.pos.equals("NNP")) {
            return "Y";
        }
        return "N";
    }

    public String calcmNumPlu() {
        if (this.pos == null) {
            return "N";
        }
        if (this.pos.equals("NNS") || this.pos.equals("NNPS")) {
            return "Y";
        }
        return "N";
    }

    public String calcmNumUnk() {
        if (this.pos == null) {
            return "N";
        }
        if (this.pos.startsWith("NN")) {
            return "N";
        }
        return "Y";
    }

    public String calcmNumber() {
        ArrayList<BaseToken> l = this.containedTokens(this.m.getBegin(), this.m.getEnd());
        for (BaseToken t : l) {
            String pos = t.getPartOfSpeech();
            if (pos.equals("NN") || pos.equals("NNP")) {
                return "S";
            }
            if (!pos.equals("NNS") && !pos.equals("NNPS")) continue;
            return "P";
        }
        return "U";
    }

    public String calcmIsDrug() {
        if (this.m.getContent() instanceof IdentifiedAnnotation && ((IdentifiedAnnotation)this.m.getContent()).getTypeID() == 1) {
            return "Y";
        }
        return "N";
    }

    public String calcmIsDisorder() {
        if (this.m.getContent() instanceof IdentifiedAnnotation && ((IdentifiedAnnotation)this.m.getContent()).getTypeID() == 2) {
            return "Y";
        }
        return "N";
    }

    public String calcmIsFinding() {
        if (this.m.getContent() instanceof IdentifiedAnnotation && ((IdentifiedAnnotation)this.m.getContent()).getTypeID() == 3) {
            return "Y";
        }
        return "N";
    }

    public String calcmIsProcedure() {
        if (this.m.getContent() instanceof IdentifiedAnnotation && ((IdentifiedAnnotation)this.m.getContent()).getTypeID() == 5) {
            return "Y";
        }
        return "N";
    }

    public String calcmIsAnatomicalSite() {
        if (this.m.getContent() instanceof IdentifiedAnnotation && ((IdentifiedAnnotation)this.m.getContent()).getTypeID() == 6) {
            return "Y";
        }
        return "N";
    }

    public String calcmWnClass() {
        if (this.m.getContent() instanceof IdentifiedAnnotation) {
            IdentifiedAnnotation ne = (IdentifiedAnnotation)this.m.getContent();
            return String.valueOf(ne.getTypeID());
        }
        return "0";
    }

    public String calcmProStr() {
        return AnaphoricityAttributeCalculator.isPronominal(this.m) ? "Y" : "N";
    }

    public String calcmIndefinite() {
        if (this.s.toLowerCase().startsWith("a ") || this.s.toLowerCase().startsWith("an ")) {
            return "Y";
        }
        return "N";
    }

    public String calcmNPHead() {
        Annotation a = this.m.getContent();
        for (LookupWindowAnnotation lwa : this.jcas.getJFSIndexRepository().getAnnotationIndex(LookupWindowAnnotation.type)) {
            if (lwa.getBegin() > a.getBegin() || lwa.getEnd() != a.getEnd()) continue;
            return "yes";
        }
        return "no";
    }

    public String calcmSimilarStr() {
        int i;
        LinkedList<Annotation> lm = FSIteratorToList.convert(this.jcas.getJFSIndexRepository().getAnnotationIndex(Sentence.type).iterator());
        ArrayList<String> contentTokens = this.contentWords(this.m.getBegin(), this.m.getEnd());
        int window = 3;
        Sentence[] sent = new Sentence[window + 1];
        for (i = 0; i <= window; ++i) {
            sent[i] = null;
        }
        for (i = 0; i < lm.size(); ++i) {
            Sentence ss;
            for (int j = 1; j <= window; ++j) {
                sent[j - 1] = sent[j];
            }
            sent[window] = ss = (Sentence)lm.get(i);
            if (ss.getBegin() <= this.m.getBegin() && ss.getEnd() >= this.m.getEnd()) {
                for (int k = window - 1; k >= 0 && sent[k] != null; --k) {
                    ArrayList<String> lt = this.contentWords(sent[k].getBegin(), sent[k].getEnd());
                    for (String s : lt) {
                        if (!contentTokens.contains(s)) continue;
                        return "Y";
                    }
                }
                continue;
            }
            if (ss.getBegin() <= this.m.getBegin()) continue;
            return "N";
        }
        return "N";
    }
}

