/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.coreference.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Set;
import org.apache.ctakes.coreference.util.AnnotOffsetComparator;
import org.apache.ctakes.coreference.util.MarkableTreeUtils;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.syntax.Chunk;
import org.apache.ctakes.typesystem.type.syntax.TerminalTreebankNode;
import org.apache.ctakes.typesystem.type.syntax.TreebankNode;
import org.apache.ctakes.typesystem.type.syntax.WordToken;
import org.apache.ctakes.typesystem.type.textsem.EntityMention;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.log4j.Logger;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.tcas.Annotation;

public class AnnotationSelector {
    public static ArrayList<Annotation> selectNE(JCas jcas) {
        ArrayList<Annotation> ret = new ArrayList<Annotation>();
        for (IdentifiedAnnotation a : jcas.getJFSIndexRepository().getAnnotationIndex(IdentifiedAnnotation.type)) {
            if (!(a instanceof EntityMention) && !(a instanceof EventMention) || a.getOntologyConceptArr() == null) continue;
            ret.add((Annotation)a);
        }
        Collections.sort(ret, new AnnotOffsetComparator());
        return ret;
    }

    public static ArrayList<BaseToken> selectBaseToken(JCas jcas) {
        ArrayList<BaseToken> ret = new ArrayList<BaseToken>();
        FSIterator iter = jcas.getJFSIndexRepository().getAnnotationIndex(BaseToken.type).iterator();
        while (iter.hasNext()) {
            ret.add((BaseToken)iter.next());
        }
        Collections.sort(ret, new AnnotOffsetComparator());
        return ret;
    }

    public static ArrayList<Sentence> selectSentence(JCas jcas) {
        ArrayList<Sentence> ret = new ArrayList<Sentence>();
        FSIterator iter = jcas.getJFSIndexRepository().getAnnotationIndex(Sentence.type).iterator();
        while (iter.hasNext()) {
            ret.add((Sentence)iter.next());
        }
        Collections.sort(ret, new AnnotOffsetComparator());
        return ret;
    }

    public static ArrayList<WordToken> selectPronoun(JCas jcas, Set<String> modalAdj, Set<String> cogved, Set<String> othervb, Logger logger) {
        Hashtable<String, WordToken> offset2token = new Hashtable<String, WordToken>();
        ArrayList<WordToken> ret = new ArrayList<WordToken>();
        for (WordToken t : jcas.getJFSIndexRepository().getAnnotationIndex(WordToken.type)) {
            String s = t.getCoveredText();
            if (s.equalsIgnoreCase("its") || s.equalsIgnoreCase("they") || s.equalsIgnoreCase("their") || s.equalsIgnoreCase("them") || s.equalsIgnoreCase("theirs")) {
                ret.add(t);
            }
            if (!s.equalsIgnoreCase("it")) continue;
            offset2token.put(t.getBegin() + "-" + t.getEnd(), t);
        }
        for (TerminalTreebankNode ttn : jcas.getJFSIndexRepository().getAnnotationIndex(TerminalTreebankNode.type)) {
            if (!ttn.getCoveredText().equalsIgnoreCase("it")) continue;
            if (AnnotationSelector.isPleonastic(ttn, modalAdj, cogved, othervb)) {
                logger.info((Object)("Pleonastic \"it\" at position " + ttn.getIndex() + " of \"" + MarkableTreeUtils.getRoot((TreebankNode)ttn).getCoveredText() + "\""));
                continue;
            }
            ret.add((WordToken)offset2token.get(ttn.getBegin() + "-" + ttn.getEnd()));
        }
        Collections.sort(ret, new AnnotOffsetComparator());
        return ret;
    }

    private static boolean isPleonastic(TerminalTreebankNode ttn, Set<String> modalAdj, Set<String> cogved, Set<String> othervb) {
        if (!ttn.getCoveredText().equalsIgnoreCase("it")) {
            return false;
        }
        if (ttn.getNodeType().equals("PRP")) {
            TreebankNode tn = ttn.getParent();
            while (tn.getNodeType().startsWith("NP")) {
                tn = tn.getParent();
            }
            if (tn.getNodeType().equals("S")) {
                String word;
                TreebankNode adjP;
                TreebankNode par = tn;
                TreebankNode vp = AnnotationSelector.findP(tn, "VP", 0);
                while (vp != null) {
                    par = vp;
                    vp = AnnotationSelector.findP(par, "VP", 0);
                }
                vp = par;
                par = vp.getParent();
                FSArray c = vp.getChildren();
                TreebankNode firstChild = (TreebankNode)c.get(0);
                if (AnnotationSelector.isBe(firstChild) ? (adjP = AnnotationSelector.findP(vp, "ADJP", 1)) != null && modalAdj.contains(adjP.getCoveredText()) && (AnnotationSelector.findP(vp, "SBAR", 1) != null || AnnotationSelector.findP(vp, "S", 1) != null || AnnotationSelector.findP(adjP, "SBAR", 1) != null || AnnotationSelector.findP(adjP, "S", 1) != null) : (AnnotationSelector.isBe(par.getChildren(0)) ? (firstChild = vp.getChildren(0)) != null && cogved.contains(firstChild.getCoveredText()) && (AnnotationSelector.findP(vp, "SBAR", 1) != null || AnnotationSelector.findP(vp, "S", 1) != null) : othervb.contains(word = firstChild.getCoveredText().replaceAll("s$", "").replaceAll("ed$", "").replaceAll("t$", "")) && (AnnotationSelector.findP(vp, "SBAR", 1) != null || AnnotationSelector.findP(vp, "S", 1) != null))) {
                    return true;
                }
            }
        }
        return false;
    }

    private static TreebankNode findP(TreebankNode n, String phraseTag, int startingChild) {
        FSArray c = n.getChildren();
        int i = startingChild;
        while (i < c.size()) {
            TreebankNode tn;
            if (!(tn = (TreebankNode)c.get(i++)).getNodeType().equals(phraseTag) && !tn.getNodeType().startsWith(phraseTag + "-")) continue;
            return tn;
        }
        return null;
    }

    private static boolean isBe(TreebankNode n) {
        String phCat = n.getNodeType();
        String txt = n.getCoveredText();
        return !(!phCat.equals("VB") && !phCat.equals("VBZ") && !phCat.equals("VBD") && !phCat.equals("VBN") || !txt.equalsIgnoreCase("is") && !txt.equalsIgnoreCase("was") && !txt.equalsIgnoreCase("been") && !txt.equalsIgnoreCase("be"));
    }

    public static ArrayList<Chunk> selectDemonAndRelative(JCas jcas) {
        ArrayList<Chunk> ret = new ArrayList<Chunk>();
        for (Chunk c : jcas.getJFSIndexRepository().getAnnotationIndex(Chunk.type)) {
            String s;
            if (!c.getChunkType().equals("NP") || !(s = c.getCoveredText().toLowerCase()).startsWith("these") && !s.startsWith("those") && !s.startsWith("this") && !s.startsWith("that") && !s.startsWith("which")) continue;
            ret.add(c);
        }
        Collections.sort(ret, new AnnotOffsetComparator());
        return ret;
    }
}

