/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.effect;

import com.icesoft.faces.component.effect.ApplyEffect;
import com.icesoft.faces.context.effects.Effect;
import com.icesoft.faces.context.effects.EffectBuilder;
import com.icesoft.faces.context.effects.JavascriptContext;
import com.icesoft.faces.context.effects.LocalEffectEncoder;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicRenderer;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ApplyEffectRenderer
extends DomBasicRenderer {
    private static Log log = LogFactory.getLog(ApplyEffectRenderer.class);

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        try {
            String parentId = uiComponent.getParent().getClientId(facesContext);
            ApplyEffect af = (ApplyEffect)uiComponent;
            Effect fx = EffectBuilder.build(af.getEffectType());
            if (fx == null) {
                log.error((Object)("No Effect for effectType [" + af.getEffectType() + "]"));
            } else {
                fx.setSequence(af.getSequence());
                fx.setSequenceId(af.getSequenceNumber());
                fx.setSubmit(af.getSubmit());
                fx.setTransitory(af.getTransitory());
                fx.setOptions(af.getOptions());
                if (af.getFire().booleanValue()) {
                    JavascriptContext.fireEffect(fx, uiComponent.getParent(), facesContext);
                    if (af.getAutoReset().booleanValue()) {
                        af.setFire(Boolean.FALSE);
                    }
                }
                if (af.getEvent() != null) {
                    String event = af.getEvent();
                    LocalEffectEncoder.encodeLocalEffect(parentId, fx, event, facesContext);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Unexpected Exception in ApplyEffectRenderer", (Throwable)e);
        }
    }
}

