/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.renderkit.dom_html_basic;

import com.icesoft.faces.component.AttributeConstants;
import com.icesoft.faces.renderkit.dom_html_basic.BaseRenderer;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicInputRenderer;
import com.icesoft.faces.renderkit.dom_html_basic.PassThruAttributeWriter;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.html.HtmlOutputText;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.icefaces.impl.util.DOMUtils;

public class OutputTextRenderer
extends BaseRenderer {
    private static final String[] passThruAttributes = AttributeConstants.getAttributes(14);

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        UIOutput component = (UIOutput)uiComponent;
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = uiComponent.getClientId(facesContext);
        if (!(component instanceof HtmlOutputText)) {
            String svalue;
            Object value = component.getValue();
            if (value != null && (svalue = String.valueOf(value)).length() > 0) {
                writer.write(svalue);
            }
            return;
        }
        if (!this.requiresSpan(uiComponent)) {
            return;
        }
        Object styleClass = uiComponent.getAttributes().get("styleClass");
        writer.startElement("span", uiComponent);
        writer.writeAttribute("id", (Object)clientId, "id");
        this.renderHtmlAttributes(facesContext, writer, uiComponent);
        if (styleClass != null) {
            writer.writeAttribute("class", styleClass, null);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        if (!(uiComponent instanceof HtmlOutputText)) {
            return;
        }
        super.encodeEnd(facesContext, uiComponent);
        ResponseWriter writer = facesContext.getResponseWriter();
        UIOutput component = (UIOutput)uiComponent;
        Object rawValue = component.getValue();
        String convertedValue = DomBasicInputRenderer.converterGetAsString(facesContext, uiComponent, rawValue);
        boolean valueTextRequiresEscape = DOMUtils.escapeIsRequired((UIComponent)uiComponent);
        if (valueTextRequiresEscape) {
            writer.writeText((Object)convertedValue, null);
        } else {
            writer.write(convertedValue);
        }
        if (!this.requiresSpan(uiComponent)) {
            return;
        }
        writer.endElement("span");
    }

    protected void renderHtmlAttributes(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent) throws IOException {
        PassThruAttributeWriter.renderHtmlAttributes(writer, uiComponent, passThruAttributes);
    }

    private boolean requiresSpan(UIComponent uiComponent) {
        Boolean nospan = (Boolean)uiComponent.getAttributes().get("nospan");
        if (nospan != null && nospan.booleanValue()) {
            return false;
        }
        String style = (String)uiComponent.getAttributes().get("style");
        String styleClass = (String)uiComponent.getAttributes().get("styleClass");
        String title = (String)uiComponent.getAttributes().get("title");
        String dir = (String)uiComponent.getAttributes().get("dir");
        String lang = (String)uiComponent.getAttributes().get("lang");
        if (styleClass != null || style != null || title != null || dir != null || lang != null) {
            return true;
        }
        String id = uiComponent.getId();
        return id != null && !id.startsWith("_") && !id.startsWith("j_id");
    }
}

