/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.jasper.xmlparser;

import com.icesoft.jasper.JasperException;
import com.icesoft.jasper.compiler.Localizer;
import com.icesoft.jasper.xmlparser.CachedEntityResolver;
import com.icesoft.jasper.xmlparser.MyErrorHandler;
import com.icesoft.jasper.xmlparser.TreeNode;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ParserUtils {
    static Log log = LogFactory.getLog(ParserUtils.class);
    static ErrorHandler errorHandler = new MyErrorHandler();
    public static EntityResolver entityResolver = new CachedEntityResolver();
    public static boolean validating = false;

    public TreeNode parseXMLDocument(String uri, InputStream is) throws JasperException {
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(validating);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(entityResolver);
            builder.setErrorHandler(errorHandler);
            document = builder.parse(is);
        }
        catch (ParserConfigurationException ex) {
            throw new JasperException(Localizer.getMessage("jsp.error.parse.xml", uri), ex);
        }
        catch (SAXParseException ex) {
            throw new JasperException(Localizer.getMessage("jsp.error.parse.xml.line", uri, Integer.toString(ex.getLineNumber()), Integer.toString(ex.getColumnNumber())), ex);
        }
        catch (SAXException sx) {
            if (log.isErrorEnabled()) {
                log.error((Object)("XML parsing failed for " + uri + "SAXException: " + sx.getMessage()));
            }
            throw new JasperException(Localizer.getMessage("jsp.error.parse.xml", uri) + "SAXException: " + sx.getMessage(), sx);
        }
        catch (IOException io) {
            throw new JasperException(Localizer.getMessage("jsp.error.parse.xml", uri), io);
        }
        return this.convert(null, document.getDocumentElement());
    }

    protected TreeNode convert(TreeNode parent, Node node) {
        NodeList children;
        TreeNode treeNode = new TreeNode(node.getNodeName(), parent);
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                Node attribute = attributes.item(i);
                treeNode.addAttribute(attribute.getNodeName(), attribute.getNodeValue());
            }
        }
        if ((children = node.getChildNodes()) != null) {
            int n = children.getLength();
            for (int i = 0; i < n; ++i) {
                Node child = children.item(i);
                if (child instanceof Comment) continue;
                if (child instanceof Text) {
                    String body = ((Text)child).getData();
                    if (body == null || (body = body.trim()).length() <= 0) continue;
                    treeNode.setBody(body);
                    continue;
                }
                TreeNode treeChild = this.convert(treeNode, child);
            }
        }
        return treeNode;
    }
}

