/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.gui.util;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.ctakes.core.resource.FileLocator;
import org.apache.log4j.Logger;

public final class IconLoader {
    private static final Logger LOGGER = Logger.getLogger((String)"IconLoader");

    private IconLoader() {
    }

    public static Icon loadIcon(String filePath, int iconSize) {
        try {
            File imageFile = FileLocator.locateFile((String)filePath);
            BufferedImage image = ImageIO.read(imageFile);
            BufferedImage scaleImage = new BufferedImage(iconSize, iconSize, 2);
            Graphics2D g = scaleImage.createGraphics();
            g.drawImage(image, 0, 0, iconSize, iconSize, null);
            return new ImageIcon(scaleImage);
        }
        catch (IOException ioE) {
            LOGGER.warn((Object)ioE.getMessage());
            return null;
        }
    }

    public static Icon loadIcon(String filePath) {
        try {
            File imageFile = FileLocator.locateFile((String)filePath);
            BufferedImage image = ImageIO.read(imageFile);
            return new ImageIcon(image);
        }
        catch (IOException ioE) {
            LOGGER.warn((Object)ioE.getMessage());
            return null;
        }
    }
}

