/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.constituency.parser.treekernel;

import java.util.ArrayList;
import org.apache.ctakes.typesystem.type.syntax.TerminalTreebankNode;
import org.apache.ctakes.typesystem.type.syntax.TopTreebankNode;
import org.apache.ctakes.typesystem.type.syntax.TreebankNode;
import org.apache.ctakes.utils.tree.SimpleTree;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;

public class TreeExtractor {
    public static SimpleTree extractPathTree(TreebankNode t1, TreebankNode t2) {
        if (t1.getBegin() > t2.getBegin()) {
            TreebankNode temp = t2;
            t2 = t1;
            t1 = temp;
        }
        if (t1 == t2 || t1.getBegin() >= t2.getBegin() && t1.getEnd() <= t2.getEnd() || t2.getBegin() >= t1.getBegin() && t2.getEnd() <= t1.getEnd()) {
            return TreeExtractor.sameTree(t1, t2);
        }
        SimpleTree node = null;
        TreebankNode lca = TreeExtractor.getLCA(t1, t2);
        node = lca == null ? new SimpleTree("TOP") : new SimpleTree(lca.getNodeType());
        ArrayList<TreebankNode> antePath = TreeExtractor.getUpwardPath(lca, t1);
        SimpleTree parent = node;
        for (TreebankNode child : antePath) {
            SimpleTree newChild = new SimpleTree(child.getNodeType());
            parent.addChild(newChild);
            parent = newChild;
        }
        parent.addChild(new SimpleTree("arg1"));
        ArrayList<TreebankNode> anaPath = TreeExtractor.getUpwardPath(lca, t2);
        parent = node;
        for (TreebankNode child : anaPath) {
            SimpleTree newChild = new SimpleTree(child.getNodeType());
            parent.addChild(newChild);
            parent = newChild;
        }
        parent.addChild(new SimpleTree("arg2"));
        return node;
    }

    public static SimpleTree extractPathEnclosedTree(TreebankNode t1, TreebankNode t2, JCas jcas) {
        SimpleTree node = null;
        if (t1.getBegin() > t2.getBegin()) {
            TreebankNode temp = t1;
            t1 = t2;
            t2 = temp;
        }
        if (t1 == t2 || t1.getBegin() >= t2.getBegin() && t1.getEnd() <= t2.getEnd() || t2.getBegin() >= t1.getBegin() && t2.getEnd() <= t1.getEnd()) {
            node = TreeExtractor.sameTree(t1, t2);
        } else {
            TreebankNode lca = TreeExtractor.getLCA(t1, t2);
            ArrayList<TreebankNode> l1 = TreeExtractor.getUpwardPath(lca, t1);
            ArrayList<TreebankNode> l2 = TreeExtractor.getUpwardPath(lca, t2);
            if (lca == null) {
                lca = new TopTreebankNode(jcas);
                lca.setNodeType("TOP");
                lca.setChildren(new FSArray(jcas, 2));
                if (l1.size() == 0) {
                    l1.add(t1);
                }
                if (l2.size() == 0) {
                    l2.add(t2);
                }
                lca.setChildren(0, l1.get(0));
                lca.setChildren(1, l2.get(0));
            }
            node = TreeExtractor.buildSimpleClonePET(lca, t1, t2);
        }
        return node;
    }

    private static SimpleTree buildSimpleClonePET(TreebankNode lca, TreebankNode t1, TreebankNode t2) {
        SimpleTree t = new SimpleTree(lca.getNodeType());
        if (lca instanceof TerminalTreebankNode) {
            t.addChild(new SimpleTree(lca.getNodeValue()));
        } else {
            for (int i = 0; i < lca.getChildren().size(); ++i) {
                TreebankNode tn = lca.getChildren(i);
                if (tn.getEnd() <= t1.getBegin() || tn.getBegin() >= t2.getEnd()) continue;
                t.addChild(TreeExtractor.buildSimpleClonePET(lca.getChildren(i), t1, t2));
            }
        }
        return t;
    }

    public static TreebankNode getLCA(TreebankNode t1, TreebankNode t2) {
        TreebankNode lca;
        TreebankNode temp = null;
        if (t2.getBegin() < t1.getBegin()) {
            temp = t1;
            t1 = t2;
            t2 = temp;
        }
        for (lca = t2; lca != null && (lca.getBegin() > t1.getBegin() || lca.getEnd() < t1.getEnd()); lca = lca.getParent()) {
        }
        return lca;
    }

    private static ArrayList<TreebankNode> getUpwardPath(TreebankNode lca, TreebankNode t) {
        ArrayList<TreebankNode> list = new ArrayList<TreebankNode>();
        while (t != null && t != lca && t.getParent() != null) {
            list.add(0, t);
            t = t.getParent();
        }
        return list;
    }

    private static SimpleTree sameTree(TreebankNode t1, TreebankNode t2) {
        SimpleTree node = new SimpleTree(t1.getNodeType());
        node.addChild(new SimpleTree("ANTECEDENT"));
        ((SimpleTree)node.children.get(0)).addChild(new SimpleTree("antecedent"));
        node.addChild(new SimpleTree("ANAPHOR"));
        ((SimpleTree)node.children.get(1)).addChild(new SimpleTree("anaphor"));
        return node;
    }

    public static SimpleTree getSurroundingTreeWithAnnotation(TreebankNode node, String string) {
        SimpleTree inner = TreeExtractor.getSimpleClone(node);
        SimpleTree outer = TreeExtractor.getSurroundingTree(node);
        String innerString = inner.toString();
        String outerString = outer.toString();
        String fullString = outerString.replace(innerString, "(" + string + " " + innerString + ")");
        return SimpleTree.fromString((String)fullString);
    }

    public static SimpleTree getSurroundingTree(TreebankNode node) {
        SimpleTree tree = null;
        while (node.getParent() != null) {
            node = node.getParent();
        }
        tree = TreeExtractor.getSimpleClone(node);
        return tree;
    }

    public static SimpleTree getSimpleClone(TreebankNode node) {
        SimpleTree t = new SimpleTree(node.getNodeType());
        if (node instanceof TerminalTreebankNode) {
            t.addChild(new SimpleTree(node.getNodeValue()));
        } else {
            for (int i = 0; i < node.getChildren().size(); ++i) {
                t.addChild(TreeExtractor.getSimpleClone(node.getChildren(i)));
            }
        }
        return t;
    }

    public static void lowercaseWords(SimpleTree t) {
        if (t.children.size() == 0) {
            t.cat = t.cat.toLowerCase();
        } else {
            for (SimpleTree child : t.children) {
                TreeExtractor.lowercaseWords(child);
            }
        }
    }
}

