/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.context;

import com.sun.xml.fastinfoset.dom.DOMDocumentParser;
import com.sun.xml.fastinfoset.dom.DOMDocumentSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialViewContext;
import javax.faces.context.ResponseWriter;
import javax.faces.context.ResponseWriterWrapper;
import org.icefaces.impl.context.BasicResponseWriter;
import org.icefaces.impl.util.DOMUtils;
import org.icefaces.util.EnvUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class DOMResponseWriter
extends ResponseWriterWrapper {
    private static Logger log = Logger.getLogger("org.icefaces.impl.context.DOMResponseWriter");
    public static final String DEFAULT_ENCODING = "UTF-8";
    private String encoding;
    public static final String DEFAULT_TYPE = "text/html";
    private String contentType;
    public static final String OLD_DOM = "org.icefaces.old-dom";
    public static final String STATE_FIELD_MARKER = "~com.sun.faces.saveStateFieldMarker~";
    protected static final String XML_MARKER = "<?xml";
    protected static final String DOCTYPE_MARKER = "<!DOCTYPE";
    private Writer writer;
    private ResponseWriter wrapped;
    private Document document;
    private Node cursor;
    private List<Node> stateNodes = new ArrayList<Node>();
    private boolean suppressNextNode = false;
    private boolean dontEscape;
    private boolean isScript;
    private boolean isStyle;

    public DOMResponseWriter(Writer writer, String encoding, String contentType) {
        this.writer = writer;
        if (writer instanceof ResponseWriter) {
            this.wrapped = (ResponseWriter)writer;
        }
        this.encoding = encoding != null ? encoding : DEFAULT_ENCODING;
        this.contentType = contentType != null ? contentType : DEFAULT_TYPE;
    }

    public ResponseWriter getWrapped() {
        return this.wrapped;
    }

    public String getCharacterEncoding() {
        return this.encoding;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        block5: {
            if (0 == len) {
                return;
            }
            if (null == this.document) {
                this.writer.write(cbuf, off, len);
                return;
            }
            try {
                String data = new String(cbuf, off, len);
                if (data.startsWith(XML_MARKER) || data.startsWith(DOCTYPE_MARKER)) {
                    this.processXMLPreamble(data);
                    return;
                }
                this.appendToCursor(data);
            }
            catch (Exception e) {
                if (!log.isLoggable(Level.INFO)) break block5;
                log.log(Level.INFO, "cannot write " + new String(cbuf, off, len), e);
            }
        }
    }

    private void processXMLPreamble(String data) throws IOException {
        FacesContext fc = FacesContext.getCurrentInstance();
        if (EnvUtils.instanceofPortletRequest(fc.getExternalContext().getRequest())) {
            return;
        }
        PartialViewContext pvc = fc.getPartialViewContext();
        if (pvc != null && pvc.isAjaxRequest()) {
            if (data.startsWith(XML_MARKER)) {
                this.storeViewAttribute(XML_MARKER, data);
            }
            if (data.startsWith(DOCTYPE_MARKER)) {
                this.storeViewAttribute(DOCTYPE_MARKER, data);
            }
        } else {
            this.writer.write(data);
        }
    }

    private void storeViewAttribute(String key, Object value) {
        FacesContext fc = FacesContext.getCurrentInstance();
        UIViewRoot root = fc.getViewRoot();
        root.getAttributes().put(key, value);
    }

    public void write(String str) throws IOException {
        if ("".equals(str)) {
            return;
        }
        if (STATE_FIELD_MARKER.equals(str)) {
            Text stateNode = this.document.createTextNode(str);
            this.stateNodes.add(stateNode);
            this.appendToCursor(stateNode);
            return;
        }
        if (null == this.document) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest(this.writer.getClass() + " raw write str " + str);
            }
            this.writer.write(str);
            return;
        }
        try {
            if (this.cursor.getNodeType() == 4) {
                CDATASection section = (CDATASection)this.cursor;
                section.appendData(str);
            } else {
                this.appendToCursor(this.document.createTextNode(str));
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "failed to write " + str, e);
        }
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
    }

    public void startDocument() throws IOException {
        this.document = DOMUtils.getNewDocument();
        this.cursor = this.document;
    }

    public void endDocument() throws IOException {
        boolean isPartialRequest = FacesContext.getCurrentInstance().getPartialViewContext().isPartialRequest();
        if (!isPartialRequest) {
            DOMUtils.printNode(this.document, this.writer);
        }
        if (null != this.document.getDocumentElement()) {
            for (Node stateNode : this.stateNodes) {
                stateNode.getParentNode().removeChild(stateNode);
            }
            this.stateNodes.clear();
            this.saveOldDocument();
        }
        this.document = null;
        this.cursor = null;
    }

    public void startElement(String name, UIComponent component) throws IOException {
        if (this.suppressNextNode) {
            this.suppressNextNode = false;
            return;
        }
        this.isScriptOrStyle(name);
        if (null == this.document) {
            this.document = DOMUtils.getNewDocument();
        }
        this.pointCursorAt(this.appendToCursor(this.document.createElement(name)));
    }

    public void endElement(String name) throws IOException {
        this.pointCursorAt(this.cursor.getParentNode());
    }

    public void writeAttribute(String name, Object value, String property) throws IOException {
        if (null == value) {
            return;
        }
        Attr attribute = this.document.createAttribute(name.trim());
        attribute.setValue(String.valueOf(value));
        this.appendToCursor(attribute);
    }

    public void writeURIAttribute(String name, Object value, String property) throws IOException {
        String stringValue = String.valueOf(value);
        if (stringValue.startsWith("javascript:")) {
            this.writeAttribute(name, stringValue, property);
        } else {
            this.writeAttribute(name, stringValue.replace(' ', '+'), property);
        }
    }

    public void writeComment(Object comment) throws IOException {
        String commentString = String.valueOf(comment);
        if (null == this.document) {
            this.writer.write(commentString);
            return;
        }
        this.appendToCursor(this.document.createComment(commentString));
    }

    public void writeText(Object text, String property) throws IOException {
        if (text == null) {
            throw new NullPointerException("WriteText method cannot write null text");
        }
        String textString = String.valueOf(text);
        if (textString.length() == 0) {
            return;
        }
        if (!this.dontEscape) {
            textString = DOMUtils.escapeAnsi(textString);
        }
        this.appendToCursor(textString);
    }

    public void writeText(char[] text, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        this.writeText(new String(text, off, len), null);
    }

    public void writeText(Object text, UIComponent component, String property) throws IOException {
        this.writeText(text, property);
    }

    public void startCDATA() throws IOException {
        if (null == this.document) {
            this.document = DOMUtils.getNewDocument();
        }
        this.pointCursorAt(this.appendToCursor(this.document.createCDATASection("")));
    }

    public void endCDATA() throws IOException {
        this.pointCursorAt(this.cursor.getParentNode());
    }

    public ResponseWriter cloneWithWriter(Writer writer) {
        String enc = this.getCharacterEncoding();
        String type = this.getContentType();
        if (writer instanceof ResponseWriter) {
            this.wrapped = (ResponseWriter)writer;
            enc = this.wrapped.getCharacterEncoding();
            type = this.wrapped.getContentType();
        }
        ResponseWriterWrapper clone = null;
        clone = writer.getClass().getName().endsWith("FastStringWriter") ? new BasicResponseWriter(writer, enc, type) : new DOMResponseWriter(writer, enc, type);
        return clone;
    }

    private Node appendToCursor(String data) {
        if (this.cursor.getNodeType() == 4) {
            CDATASection section = (CDATASection)this.cursor;
            section.appendData(data);
            return section;
        }
        return this.appendToCursor(this.document.createTextNode(data));
    }

    private Node appendToCursor(Node node) {
        try {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("appending " + DOMUtils.toDebugString(node) + " into " + DOMUtils.toDebugString(this.cursor));
            }
            if (this.cursor == null) {
                this.cursor = this.document.getDocumentElement();
            }
            return this.cursor.appendChild(node);
        }
        catch (DOMException e) {
            String message = "failed to append " + DOMUtils.toDebugString(node) + " into " + DOMUtils.toDebugString(this.cursor);
            log.log(Level.SEVERE, message, e);
            throw new RuntimeException(message, e);
        }
    }

    private Node appendToCursor(Attr node) {
        try {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Appending " + DOMUtils.toDebugString(node) + " into " + DOMUtils.toDebugString(this.cursor));
            }
            Attr result = ((Element)this.cursor).setAttributeNode(node);
            if ("id".equals(node.getName())) {
                ((Element)this.cursor).setIdAttributeNode(node, true);
            }
            return result;
        }
        catch (DOMException e) {
            String message = "failed to append " + DOMUtils.toDebugString(node) + " into " + DOMUtils.toDebugString(this.cursor);
            log.log(Level.SEVERE, message, e);
            throw new RuntimeException(message, e);
        }
        catch (ClassCastException e) {
            String message = "cursor is not an element: " + DOMUtils.toDebugString(this.cursor);
            log.log(Level.SEVERE, message, e);
            throw new RuntimeException(message, e);
        }
    }

    private void pointCursorAt(Node node) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("moving cursor to " + DOMUtils.toDebugString(node));
        }
        this.cursor = node;
    }

    public void startSubtreeRendering() {
        Document oldDoc = this.getOldDocument();
        if (oldDoc != null) {
            this.document = oldDoc;
        } else {
            this.refreshDocument();
        }
    }

    public Node seekSubtree(String id) {
        Node oldSubtree = null;
        this.cursor = this.document.getElementById(id);
        if (null == this.cursor) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "unable to seek to component DOM subtree " + id);
            }
            return null;
        }
        oldSubtree = this.cursor;
        Element newSubtree = this.document.createElement(this.cursor.getNodeName());
        Node cursorParent = this.cursor.getParentNode();
        cursorParent.replaceChild(newSubtree, this.cursor);
        this.cursor = newSubtree;
        this.suppressNextNode = true;
        return oldSubtree;
    }

    public Document getDocument() {
        return this.document;
    }

    public void saveOldDocument() throws IOException {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (!EnvUtils.isCompressDOM(facesContext)) {
            facesContext.getViewRoot().getViewMap().put(OLD_DOM, this.document);
            return;
        }
        DOMDocumentSerializer serializer = new DOMDocumentSerializer();
        ByteArrayOutputStream out = new ByteArrayOutputStream(10000);
        serializer.setOutputStream((OutputStream)out);
        serializer.serialize(this.document);
        byte[] data = out.toByteArray();
        facesContext.getViewRoot().getViewMap().put(OLD_DOM, data);
    }

    public Document getOldDocument() {
        return DOMResponseWriter.getOldDocument(FacesContext.getCurrentInstance());
    }

    public static Document getOldDocument(FacesContext facesContext) {
        Object oldDOMObject = facesContext.getViewRoot().getViewMap().get(OLD_DOM);
        if (null == oldDOMObject) {
            return null;
        }
        if (!EnvUtils.isCompressDOM(facesContext)) {
            return (Document)oldDOMObject;
        }
        Document document = DOMUtils.getNewDocument();
        document.setStrictErrorChecking(false);
        try {
            byte[] data = (byte[])oldDOMObject;
            DOMDocumentParser parser = new DOMDocumentParser();
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            parser.parse(document, (InputStream)in);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Failed to restore old DOM ", e);
        }
        return document;
    }

    public Node getCursorParent() {
        return this.cursor;
    }

    public void setCursorParent(Node cursorParent) {
        this.cursor = cursorParent;
    }

    private void refreshDocument() {
        this.document = DOMUtils.getNewDocument();
        Element root = this.document.createElement("html");
        this.document.appendChild(root);
        this.cursor = this.document.getDocumentElement();
    }

    private boolean isScriptOrStyle(String name) {
        if ("script".equalsIgnoreCase(name)) {
            this.isScript = true;
            this.dontEscape = true;
        } else if ("style".equalsIgnoreCase(name)) {
            this.isStyle = true;
            this.dontEscape = true;
        } else {
            this.isScript = false;
            this.isStyle = false;
            this.dontEscape = false;
        }
        return this.isScript || this.isStyle;
    }
}

