/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.sideeffect.util;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PatternMatch {
    private List<String> keywords;
    private String regex;
    private String input;
    public Pattern pat;
    public Matcher mat;

    public PatternMatch(String expr, String in, List<String> kw) {
        StringBuffer sb = new StringBuffer();
        for (String s : kw) {
            sb.append(s + "|");
        }
        this.regex = expr.replaceAll("KW", sb.substring(0, sb.length() - 1));
        this.input = in;
        this.keywords = kw;
        this.pat = Pattern.compile(this.regex);
        this.mat = this.pat.matcher(this.input);
    }

    public PatternMatch(String expr, String in) {
        this.regex = expr;
        this.input = in;
        this.pat = Pattern.compile(this.regex);
        this.mat = this.pat.matcher(this.input);
    }

    public boolean isDrugBetween(int begin, int end) {
        return this.input.substring(begin, end).matches(".*<DRUG>.*");
    }

    public boolean isDrugBetween(int begin, int end, int[] span) {
        Pattern p = Pattern.compile("(<DRUG>)");
        Matcher m = p.matcher(this.input.substring(begin, end));
        if (m.find()) {
            span[0] = m.start() + begin;
            span[1] = m.end() + begin;
            return true;
        }
        return false;
    }

    public boolean isPseBetween(int begin, int end) {
        return this.input.substring(begin, end).matches(".*<PSE>.*");
    }

    public boolean isPseBetween(int begin, int end, int[] span) {
        Pattern p = Pattern.compile("(<PSE>)");
        Matcher m = p.matcher(this.input.substring(begin, end));
        if (m.find()) {
            span[0] = m.start() + begin;
            span[1] = m.end() + begin;
            return true;
        }
        return false;
    }

    public boolean isDistantBetween(int begin, int end) {
        String s = this.input.substring(begin, end).replaceAll("<DRUG>|<PSE>", "");
        return !s.matches("(\\sand\\s)|(\\sor\\s)|(,)|(,\\s)|(\\s,\\s)");
    }
}

