/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.beam;

import com.googlecode.clearnlp.classification.prediction.StringPrediction;
import java.util.ArrayList;
import java.util.List;

public class BeamNode<T>
implements Comparable<BeamNode<T>> {
    private BeamNode<T> g_prevNode = null;
    private StringPrediction g_prediction = null;
    private T g_configuration = null;

    public BeamNode(BeamNode<T> prevNode, StringPrediction prediction) {
        this.g_prevNode = prevNode;
        this.g_prediction = prediction;
    }

    public BeamNode<T> getPrevNode() {
        return this.g_prevNode;
    }

    public T getConfiguration() {
        return this.g_configuration;
    }

    public String getLabel() {
        return this.g_prediction.label;
    }

    public double getScore() {
        return this.g_prediction.score;
    }

    public void setPrevNode(BeamNode<T> prevNode) {
        this.g_prevNode = prevNode;
    }

    public void setPrediction(StringPrediction prediction) {
        this.g_prediction = prediction;
    }

    public List<BeamNode<T>> getSequence() {
        ArrayList<BeamNode<T>> nodes = new ArrayList<BeamNode<T>>();
        for (BeamNode<T> node = this; node != null; node = node.getPrevNode()) {
            nodes.add(node);
        }
        return nodes;
    }

    public List<BeamNode<T>> getSequence(int n) {
        ArrayList<BeamNode<T>> nodes = new ArrayList<BeamNode<T>>();
        BeamNode<T> node = this;
        for (int i = 0; i < n && node != null; node = node.getPrevNode(), ++i) {
            nodes.add(node);
        }
        return nodes;
    }

    @Override
    public int compareTo(BeamNode<T> node) {
        double d = this.getScore() - node.getScore();
        if (d > 0.0) {
            return -1;
        }
        if (d < 0.0) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return this.getLabel() + ":" + this.getScore();
    }
}

