/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.demo;

import com.googlecode.clearnlp.component.AbstractComponent;
import com.googlecode.clearnlp.component.dep.ONDEPPassParser;
import com.googlecode.clearnlp.component.pos.ONPOSTagger;
import com.googlecode.clearnlp.dependency.DEPTree;
import com.googlecode.clearnlp.engine.EngineGetter;
import com.googlecode.clearnlp.nlp.NLPDecode;
import com.googlecode.clearnlp.tokenization.AbstractTokenizer;
import java.io.FileInputStream;
import java.util.zip.ZipInputStream;

public class DemoONDecoder {
    final String language = "en";

    public DemoONDecoder(String dictFile, String posModelFile, String depModelFile, String predModelFile, String roleModelFile, String srlModelFile) throws Exception {
        AbstractTokenizer tokenizer = EngineGetter.getTokenizer("en", new FileInputStream(dictFile));
        AbstractComponent analyzer = EngineGetter.getComponent(new FileInputStream(dictFile), "en", "morph");
        AbstractComponent identifier = EngineGetter.getComponent(new FileInputStream(predModelFile), "en", "pred");
        AbstractComponent classifier = EngineGetter.getComponent(new FileInputStream(roleModelFile), "en", "role");
        AbstractComponent labeler = EngineGetter.getComponent(new FileInputStream(srlModelFile), "en", "srl");
        ONPOSTagger tagger = new ONPOSTagger(new ZipInputStream(new FileInputStream(posModelFile)), 0.01, 0.1);
        ONDEPPassParser parser = new ONDEPPassParser(new ZipInputStream(new FileInputStream(depModelFile)), 0.01, 0.1);
        AbstractComponent[] components = new AbstractComponent[]{tagger, analyzer, parser, identifier, classifier, labeler};
        String sentence = "CUTE GIRL AT SAFEWAY JUST SMILED AT ME";
        DEPTree tree = this.process(tokenizer, components, sentence);
        tree.get((int)1).pos = "JJ";
        tree.get((int)2).pos = "NN";
        tree.get((int)3).pos = "IN";
        tree.get((int)7).pos = "IN";
        tree.get((int)8).pos = "PRP";
        tagger.trainHard(tree, 10);
        tree = this.process(tokenizer, components, sentence);
        sentence = "Is this person's sex male or female?";
        tree = this.process(tokenizer, components, sentence);
        tree.get(3).setHead(tree.get(5), "poss");
        tree.get(5).setHead(tree.get(1), "nsubj");
        tree.get(6).setHead(tree.get(1), "attr");
        parser.trainHard(tree, 10);
        tree = this.process(tokenizer, components, sentence);
    }

    public DEPTree process(AbstractTokenizer tokenizer, AbstractComponent[] components, String sentence) {
        NLPDecode nlp = new NLPDecode();
        DEPTree tree = nlp.toDEPTree(tokenizer.getTokens(sentence));
        for (AbstractComponent component : components) {
            component.process(tree);
        }
        System.out.println(tree.toStringSRL() + "\n");
        return tree;
    }

    public static void main(String[] args) {
        String dictFile = args[0];
        String posModelFile = args[1];
        String depModelFile = args[2];
        String predModelFile = args[3];
        String roleModelFile = args[4];
        String srlModelFile = args[5];
        try {
            new DemoONDecoder(dictFile, posModelFile, depModelFile, predModelFile, roleModelFile, srlModelFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

