/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.propbank;

import com.carrotsearch.hppc.IntContainer;
import com.carrotsearch.hppc.IntOpenHashSet;
import com.googlecode.clearnlp.constituent.CTTree;
import com.googlecode.clearnlp.propbank.PBLoc;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

public class PBArg
implements Comparable<PBArg> {
    public String label;
    protected List<PBLoc> l_locs = new ArrayList<PBLoc>();

    public PBArg() {
    }

    public PBArg(String str) {
        int idx = str.indexOf("-");
        if (idx == -1) {
            System.err.println("Error: illegal format - " + str);
            System.exit(1);
        }
        this.label = str.substring(idx + 1);
        StringTokenizer tok = new StringTokenizer(str.substring(0, idx), "*&,;", true);
        if (!tok.hasMoreTokens()) {
            System.err.println("Error: illegal format - " + str);
            System.exit(1);
        }
        this.addLoc(new PBLoc(tok.nextToken(), ""));
        while (tok.hasMoreTokens()) {
            String type = tok.nextToken();
            if (!tok.hasMoreTokens()) {
                System.err.println("Error: illegal format - " + str);
                System.exit(1);
            }
            this.addLoc(new PBLoc(tok.nextToken(), type));
        }
    }

    public boolean isLabel(String label) {
        return this.label.equals(label);
    }

    public PBLoc getLoc(int index) {
        return 0 <= index && index < this.l_locs.size() ? this.l_locs.get(index) : null;
    }

    public PBLoc getLoc(int terminalId, int height) {
        for (PBLoc loc : this.l_locs) {
            if (!loc.equals(terminalId, height)) continue;
            return loc;
        }
        return null;
    }

    public List<PBLoc> getLocs() {
        return this.l_locs;
    }

    public IntOpenHashSet getTerminalIdSet(CTTree tree) {
        IntOpenHashSet set = new IntOpenHashSet();
        for (PBLoc loc : this.l_locs) {
            set.addAll((IntContainer)tree.getNode(loc).getSubTerminalIdSet());
        }
        return set;
    }

    public int[] getSortedTerminalIdList(CTTree tree) {
        IntOpenHashSet set = this.getTerminalIdSet(tree);
        int[] ids = set.toArray();
        Arrays.sort(ids);
        return ids;
    }

    public void addLoc(PBLoc loc) {
        this.l_locs.add(loc);
    }

    public void addLocs(Collection<PBLoc> locs) {
        this.l_locs.addAll(locs);
    }

    public void removeLoc(int terminalId, int height) {
        for (PBLoc loc : this.l_locs) {
            if (!loc.equals(terminalId, height)) continue;
            this.l_locs.remove(loc);
            break;
        }
    }

    public void removeLocs(Collection<PBLoc> locs) {
        this.l_locs.removeAll(locs);
        if (!this.l_locs.isEmpty()) {
            this.l_locs.get((int)0).type = "";
        }
    }

    public void replaceLocs(List<PBLoc> locs) {
        this.l_locs = locs;
    }

    public void sortLocs() {
        if (this.l_locs.isEmpty()) {
            return;
        }
        Collections.sort(this.l_locs);
        PBLoc fst = this.l_locs.get(0);
        if (!fst.type.equals("")) {
            for (int i = 1; i < this.l_locs.size(); ++i) {
                PBLoc loc = this.l_locs.get(i);
                if (!loc.type.equals("")) continue;
                loc.type = fst.type;
                break;
            }
            fst.type = "";
        }
    }

    public int getLocSize() {
        return this.l_locs.size();
    }

    public boolean hasNoLoc() {
        return this.l_locs.isEmpty();
    }

    public boolean hasType(String type) {
        for (PBLoc loc : this.l_locs) {
            if (!loc.isType(type)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder build = new StringBuilder();
        for (PBLoc loc : this.l_locs) {
            build.append(loc.toString());
        }
        build.append("-");
        build.append(this.label);
        return build.toString();
    }

    @Override
    public int compareTo(PBArg arg) {
        return this.getLoc(0).compareTo(arg.getLoc(0));
    }
}

