/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.run;

import com.googlecode.clearnlp.run.AbstractRun;
import com.googlecode.clearnlp.util.UTInput;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.kohsuke.args4j.Option;

public class POSEvaluate
extends AbstractRun {
    @Option(name="-g", usage="gold-standard file (required)", required=true, metaVar="<filename>")
    private String s_goldFile;
    @Option(name="-s", usage="system-generated file (required)", required=true, metaVar="<filename>")
    private String s_autoFile;
    @Option(name="-gi", usage="column index of POS tags in a gold-standard file (required)", required=true, metaVar="<integer>")
    private int i_goldIndex;
    @Option(name="-si", usage="column index of POS tags in a system-generated file (required)", required=true, metaVar="<integer>")
    private int i_autoIndex;
    private Map<String, int[]> m_labels;

    public POSEvaluate() {
    }

    public POSEvaluate(String[] args) {
        this.initArgs(args);
        this.run(this.s_goldFile, this.s_autoFile, this.i_goldIndex - 1, this.i_autoIndex - 1);
    }

    public void run(String goldFile, String autoFile, int goldIndex, int autoIndex) {
        BufferedReader fGold = UTInput.createBufferedFileReader(goldFile);
        BufferedReader fAuto = UTInput.createBufferedFileReader(autoFile);
        this.m_labels = new HashMap<String, int[]>();
        try {
            String line;
            while ((line = fGold.readLine()) != null) {
                String[] gold = line.split("\t");
                String[] auto = fAuto.readLine().split("\t");
                if ((line = line.trim()).isEmpty()) continue;
                int[] counts = this.getCounts(gold[goldIndex]);
                if (gold[goldIndex].equals(auto[autoIndex])) {
                    counts[0] = counts[0] + 1;
                }
                counts[1] = counts[1] + 1;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.print();
    }

    private void print() {
        String hline = "----------------------------------------";
        System.out.println(hline);
        System.out.printf("%10s%10s%10s%10s\n", "Label", "Count", "Dist.", "Acc.");
        System.out.println(hline);
        int[] counts = this.getTotalCounts();
        int total = counts[1];
        this.printAccuracy("ALL", total, counts);
        System.out.println(hline);
        ArrayList<String> tags = new ArrayList<String>(this.m_labels.keySet());
        Collections.sort(tags);
        for (String tag : tags) {
            this.printAccuracy(tag, total, this.m_labels.get(tag));
        }
        System.out.println(hline);
    }

    private void printAccuracy(String label, int total, int[] counts) {
        System.out.printf("%10s%10d%10.2f%10.2f\n", label, counts[1], 100.0 * (double)counts[1] / (double)total, 100.0 * (double)counts[0] / (double)counts[1]);
    }

    private int[] getCounts(String tag) {
        int[] counts;
        if (this.m_labels.containsKey(tag)) {
            counts = this.m_labels.get(tag);
        } else {
            counts = new int[2];
            this.m_labels.put(tag, counts);
        }
        return counts;
    }

    private int[] getTotalCounts() {
        int[] gCounts = null;
        for (String tag : this.m_labels.keySet()) {
            int[] lCounts = this.m_labels.get(tag);
            if (gCounts == null) {
                gCounts = Arrays.copyOf(lCounts, lCounts.length);
                continue;
            }
            for (int i = 0; i < gCounts.length; ++i) {
                int n = i;
                gCounts[n] = gCounts[n] + lCounts[i];
            }
        }
        return gCounts;
    }

    public static void main(String[] args) {
        new POSEvaluate(args);
    }
}

