/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.run;

import com.googlecode.clearnlp.dependency.DEPFeat;
import com.googlecode.clearnlp.dependency.srl.SRLEval;
import com.googlecode.clearnlp.run.AbstractRun;
import com.googlecode.clearnlp.util.UTInput;
import java.io.BufferedReader;
import java.io.IOException;
import org.kohsuke.args4j.Option;

public class PredEvaluate
extends AbstractRun {
    @Option(name="-g", usage="gold-standard file (required)", required=true, metaVar="<filename>")
    private String s_goldFile;
    @Option(name="-s", usage="system-generated file (required)", required=true, metaVar="<filename>")
    private String s_autoFile;
    @Option(name="-gi", usage="column index of extra features in a gold-standard file (required)", required=true, metaVar="<integer>")
    private int i_goldIndex;
    @Option(name="-si", usage="column index of extra features in a system-generated file (required)", required=true, metaVar="<integer>")
    private int i_autoIndex;
    @Option(name="-z", usage="true for predicate identification, false for roleset classification (default)", required=false, metaVar="<boolean>")
    private boolean b_pred;

    public PredEvaluate() {
    }

    public PredEvaluate(String[] args) {
        this.initArgs(args);
        this.run(this.s_goldFile, this.s_autoFile, this.i_goldIndex - 1, this.i_autoIndex - 1, this.b_pred);
    }

    public void run(String goldFile, String autoFile, int goldIndex, int autoIndex, boolean bPred) {
        BufferedReader fGold = UTInput.createBufferedFileReader(goldFile);
        BufferedReader fAuto = UTInput.createBufferedFileReader(autoFile);
        int[] counts = new int[]{0, 0, 0};
        try {
            String line;
            while ((line = fGold.readLine()) != null) {
                String aPred;
                String gPred;
                String[] gold = line.split("\t");
                String[] auto = fAuto.readLine().split("\t");
                if ((line = line.trim()).isEmpty()) continue;
                DEPFeat gFeats = new DEPFeat(gold[goldIndex]);
                DEPFeat aFeats = new DEPFeat(auto[autoIndex]);
                if (bPred) {
                    gPred = (String)gFeats.get("pb");
                    if (gPred != null) {
                        counts[1] = counts[1] + 1;
                    }
                    if ((aPred = (String)aFeats.get("pb")) != null) {
                        counts[2] = counts[2] + 1;
                    }
                    if (gPred == null || aPred == null) continue;
                    counts[0] = counts[0] + 1;
                    continue;
                }
                gPred = (String)gFeats.get("pb");
                if (gPred == null) continue;
                aPred = (String)aFeats.get("pb");
                counts[1] = counts[1] + 1;
                counts[2] = counts[2] + 1;
                if (!gPred.equals(aPred)) continue;
                counts[0] = counts[0] + 1;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.print(counts);
    }

    private void print(int[] counts) {
        double p = 100.0 * (double)counts[0] / (double)counts[2];
        double r = 100.0 * (double)counts[0] / (double)counts[1];
        System.out.printf("Precision: %5.2f (%d/%d)\n", p, counts[0], counts[2]);
        System.out.printf("Recall   : %5.2f (%d/%d)\n", r, counts[0], counts[1]);
        System.out.printf("F1-score : %5.2f\n", SRLEval.getF1(p, r));
    }

    public static void main(String[] args) {
        new PredEvaluate(args);
    }
}

