/*
 * Decompiled with CFR 0.152.
 */
package de.tudarmstadt.ukp.dkpro.core.api.resources;

import de.tudarmstadt.ukp.dkpro.core.api.resources.HasResourceMetadata;
import de.tudarmstadt.ukp.dkpro.core.api.resources.ResourceUtils;
import de.tudarmstadt.ukp.dkpro.core.api.resources.internal.ApacheCommonsLoggingAdapter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.resolver.ChainResolver;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.plugins.resolver.IBiblioResolver;
import org.apache.ivy.plugins.resolver.ResolverSettings;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.MessageLogger;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.PropertyPlaceholderHelper;

public abstract class ResourceObjectProviderBase<M>
implements HasResourceMetadata {
    private final Log log = LogFactory.getLog(ResourceObjectProviderBase.class);
    public static final String PROP_REPO_ID = "dkpro.model.repository.id";
    public static final String PROP_REPO_URL = "dkpro.model.repository.url";
    private static final String DEFAULT_REPO_ID = "ukp-model-releases";
    private static final String DEFAULT_REPO_URL = "http://zoidberg.ukp.informatik.tu-darmstadt.de/artifactory/public-model-releases-local";
    public static final String NOT_REQUIRED = "-=* NOT REQUIRED *=-";
    public static final String LANGUAGE = "language";
    public static final String VARIANT = "variant";
    public static final String LOCATION = "location";
    public static final String GROUP_ID = "groupId";
    public static final String ARTIFACT_ID = "artifactId";
    public static final String VERSION = "version";
    public static final String PACKAGE = "package";
    private Properties resourceMetaData;
    private URL resourceUrl;
    private URL initialResourceUrl;
    private String lastModelLocation;
    private M resource;
    private Object contextObject;
    private Properties overrides = new Properties();
    private Properties defaults = new Properties();
    private Properties defaultVariants = null;
    private String defaultVariantsLocation;
    private Map<String, HasResourceMetadata> imports = new HashMap<String, HasResourceMetadata>();
    private ExtensibleURLClassLoader loader = new ExtensibleURLClassLoader(this.getClass().getClassLoader());
    private PropertyPlaceholderHelper pph = new PropertyPlaceholderHelper("${", "}", null, false);

    public ResourceObjectProviderBase() {
        this.init();
    }

    protected void init() {
        this.setDefault(GROUP_ID, "de.tudarmstadt.ukp.dkpro.core");
    }

    public void setOverride(String aKey, String aValue) {
        if (aValue == null) {
            this.overrides.remove(aKey);
        } else {
            this.overrides.setProperty(aKey, aValue);
        }
    }

    public String getOverride(String aKey) {
        return (String)this.overrides.get(aKey);
    }

    public void removeOverride(String aKey) {
        this.overrides.remove(aKey);
    }

    public void setDefault(String aKey, String aValue) {
        if (aValue == null) {
            this.defaults.remove(aKey);
        } else {
            this.defaults.setProperty(aKey, aValue);
        }
    }

    public String getDefault(String aKey) {
        return (String)this.defaults.get(aKey);
    }

    public void removeDefault(String aKey) {
        this.defaults.remove(aKey);
    }

    public void addImport(String aString, HasResourceMetadata aSource) {
        this.imports.put(aString, aSource);
    }

    public void removeImport(String aString) {
        this.imports.remove(aString);
    }

    public void setDefaultVariantsLocation(String aLocation) {
        this.defaultVariantsLocation = aLocation;
    }

    public void setDefaultVariants(Properties aDefaultVariants) {
        if (aDefaultVariants.size() == 0) {
            this.log.warn((Object)"setDefaultVariants called with zero-sized variants map.");
            this.defaultVariants = null;
        } else {
            this.defaultVariants = new Properties();
            this.defaultVariants.putAll((Map<?, ?>)aDefaultVariants);
        }
    }

    public void setContextObject(Object aObject) {
        this.contextObject = aObject;
        this.setDefault(PACKAGE, aObject.getClass().getPackage().getName().replace('.', '/'));
    }

    protected String getModelVersionFromMavenPom() throws IOException {
        Model model;
        if (this.contextObject == null) {
            throw new IllegalStateException("No context object specified");
        }
        Properties props = this.getAggregatedProperties();
        String modelArtifact = this.pph.replacePlaceholders(props.getProperty(ARTIFACT_ID), props);
        String modelGroup = this.pph.replacePlaceholders(props.getProperty(GROUP_ID), props);
        URL url = this.contextObject.getClass().getResource(this.contextObject.getClass().getSimpleName() + ".class");
        String classPart = this.contextObject.getClass().getName().replace(".", "/") + ".class";
        String base = url.toString();
        base = base.substring(0, base.length() - classPart.length());
        URL pomUrl = null;
        String extraNotFoundInfo = "";
        if ("file".equals(url.getProtocol()) && base.endsWith("target/classes/")) {
            File pomFile = new File(new File(URI.create(base = base.substring(0, base.length() - "target/classes/".length()))), "pom.xml");
            if (pomFile.exists()) {
                pomUrl = pomFile.toURI().toURL();
            } else {
                extraNotFoundInfo = " Since it looks like you are running a Maven build, it POM file was also searched for at [" + pomFile + "], but it doesn't exist there.";
            }
        }
        if (pomUrl == null) {
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
            String pomPattern = base + "META-INF/maven/" + modelGroup + "/*/pom.xml";
            Resource[] resources = resolver.getResources(pomPattern);
            if (resources.length == 0) {
                throw new FileNotFoundException("No POM file found using [" + pomPattern + "]" + extraNotFoundInfo);
            }
            if (resources.length > 2) {
                throw new IllegalStateException("Found more than one POM file found using [" + pomPattern + "]");
            }
            pomUrl = resources[0].getURL();
        }
        try {
            MavenXpp3Reader reader = new MavenXpp3Reader();
            model = reader.read(pomUrl.openStream());
        }
        catch (XmlPullParserException e) {
            throw new IOException(e);
        }
        if (model.getDependencyManagement() != null && model.getDependencyManagement().getDependencies() != null) {
            List deps = model.getDependencyManagement().getDependencies();
            for (Dependency dep : deps) {
                if (!StringUtils.equals((String)dep.getGroupId(), (String)modelGroup) || !StringUtils.equals((String)dep.getArtifactId(), (String)modelArtifact)) continue;
                return dep.getVersion();
            }
        }
        throw new IllegalStateException("No version information found in [" + pomUrl + "]");
    }

    protected String getModelLocation() throws IOException {
        return this.getModelLocation(null);
    }

    protected String getModelLocation(Properties aProperties) throws IOException {
        Properties props = aProperties;
        if (props == null) {
            props = this.getAggregatedProperties();
        }
        try {
            return this.pph.replacePlaceholders(props.getProperty(LOCATION), props);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Unable to resolve the model location [" + props.getProperty(LOCATION) + "]: " + e.getMessage() + ". Possibly there is " + "no default model configured for the specified language [" + props.getProperty(LANGUAGE) + "] or the language is set incorrectly.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure() throws IOException {
        boolean success = false;
        Properties props = this.getAggregatedProperties();
        String modelLocation = this.getModelLocation(props);
        boolean modelLocationChanged = !StringUtils.equals((String)modelLocation, (String)this.lastModelLocation);
        this.lastModelLocation = modelLocation;
        try {
            if (NOT_REQUIRED.equals(modelLocation)) {
                this.resourceUrl = null;
                this.initialResourceUrl = null;
                if (modelLocationChanged) {
                    this.log.info((Object)"Producing resource from thin air");
                    this.resource = this.produceResource(null);
                }
            } else {
                URL initialUrl;
                try {
                    initialUrl = ResourceUtils.resolveLocation(modelLocation, this.loader, null);
                }
                catch (IOException e) {
                    if (modelLocationChanged) {
                        try {
                            this.resolveDependency(props);
                        }
                        catch (Throwable re) {
                            throw this.handleResolvingError(e, this.lastModelLocation, props);
                        }
                        try {
                            initialUrl = ResourceUtils.resolveLocation(modelLocation, this.loader, null);
                        }
                        catch (Throwable re) {
                            throw this.handleResolvingError(e, this.lastModelLocation, props);
                        }
                    }
                    throw this.handleResolvingError(e, this.lastModelLocation, props);
                }
                if (!ResourceObjectProviderBase.equals(this.initialResourceUrl, initialUrl)) {
                    this.initialResourceUrl = initialUrl;
                    this.resourceMetaData = new Properties();
                    this.resourceUrl = this.followRedirects(this.initialResourceUrl);
                    this.loadMetadata();
                    this.loadResource();
                }
            }
            success = true;
        }
        finally {
            if (!success) {
                this.resourceUrl = null;
                this.resource = null;
            }
        }
    }

    private static boolean equals(URL aUrl1, URL aUrl2) {
        if (aUrl1 == aUrl2) {
            return true;
        }
        if (aUrl1 == null || aUrl2 == null) {
            return false;
        }
        return aUrl1.toString().equals(aUrl2.toString());
    }

    protected URL followRedirects(URL aUrl) throws IOException {
        URL url = aUrl;
        while (url.getPath().endsWith(".properties")) {
            Properties tmpResourceMetaData = PropertiesLoaderUtils.loadProperties((Resource)new UrlResource(url));
            this.resourceMetaData.remove(LOCATION);
            this.mergeProperties(this.resourceMetaData, tmpResourceMetaData);
            String redirect = this.resourceMetaData.getProperty(LOCATION);
            if (redirect == null) {
                throw new IOException("Model URL resolves to properties at [" + url + "] but no redirect property [" + LOCATION + "] found there.");
            }
            url = ResourceUtils.resolveLocation(redirect, this.loader, null);
        }
        return url;
    }

    protected void loadMetadata() throws IOException {
        URL modelMetaDataUrl;
        String modelMetaDataLocation;
        Properties modelMetaData = null;
        try {
            modelMetaDataLocation = this.getModelMetaDataLocation(this.resourceUrl.toString());
            modelMetaDataUrl = ResourceUtils.resolveLocation(modelMetaDataLocation, this.loader, null);
            modelMetaData = PropertiesLoaderUtils.loadProperties((Resource)new UrlResource(modelMetaDataUrl));
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        if (modelMetaData == null) {
            try {
                modelMetaDataLocation = this.getModelMetaDataLocation(this.lastModelLocation);
                modelMetaDataUrl = ResourceUtils.resolveLocation(modelMetaDataLocation, this.loader, null);
                modelMetaData = PropertiesLoaderUtils.loadProperties((Resource)new UrlResource(modelMetaDataUrl));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        if (modelMetaData != null) {
            this.mergeProperties(this.resourceMetaData, modelMetaData);
        }
    }

    private String getModelMetaDataLocation(String aLocation) {
        String baseLocation = aLocation;
        if (baseLocation.toLowerCase().endsWith(".gz")) {
            baseLocation = baseLocation.substring(0, baseLocation.length() - 3);
        } else if (baseLocation.toLowerCase().endsWith(".bz2")) {
            baseLocation = baseLocation.substring(0, baseLocation.length() - 4);
        }
        String modelMetaDataLocation = FilenameUtils.removeExtension((String)baseLocation) + ".properties";
        return modelMetaDataLocation;
    }

    protected void loadResource() throws IOException {
        if (this.initialResourceUrl.equals(this.resourceUrl)) {
            this.log.info((Object)("Producing resource from " + this.resourceUrl));
        } else {
            this.log.info((Object)("Producing resource from [" + this.resourceUrl + "] redirected from [" + this.initialResourceUrl + "]"));
        }
        this.resource = this.produceResource(this.resourceUrl);
    }

    private void resolveDependency(Properties aProps) throws IOException, IllegalStateException {
        Set<String> names = aProps.stringPropertyNames();
        if (names.contains(ARTIFACT_ID) && names.contains(GROUP_ID)) {
            String artifactId = this.pph.replacePlaceholders(aProps.getProperty(ARTIFACT_ID), aProps);
            String groupId = this.pph.replacePlaceholders(aProps.getProperty(GROUP_ID), aProps);
            String version = this.pph.replacePlaceholders(aProps.getProperty(VERSION, ""), aProps);
            try {
                version = this.getModelVersionFromMavenPom();
            }
            catch (IOException e) {
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
            try {
                List<File> files = this.resolveWithIvy(groupId, artifactId, version);
                for (File file : files) {
                    this.loader.addURL(file.toURI().toURL());
                }
            }
            catch (ParseException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    protected DependencyResolver getModelResolver() {
        IBiblioResolver ukpModels = new IBiblioResolver();
        ukpModels.setName(System.getProperty(PROP_REPO_ID, DEFAULT_REPO_ID));
        ukpModels.setRoot(System.getProperty(PROP_REPO_URL, DEFAULT_REPO_URL));
        ukpModels.setM2compatible(true);
        return ukpModels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<File> resolveWithIvy(String aGroupId, String aArtifactId, String aVersion) throws ParseException, IOException {
        ResolveReport report;
        Message.setDefaultLogger((MessageLogger)new ApacheCommonsLoggingAdapter(this.log));
        IvySettings ivySettings = new IvySettings();
        ivySettings.loadDefault();
        ivySettings.configureRepositories(true);
        ivySettings.configureDefaultVersionMatcher();
        DependencyResolver modelResolver = this.getModelResolver();
        modelResolver.setSettings((ResolverSettings)ivySettings);
        ivySettings.addResolver(modelResolver);
        ((ChainResolver)ivySettings.getResolver("main")).add(modelResolver);
        Ivy ivy = Ivy.newInstance((IvySettings)ivySettings);
        UUID uuid = UUID.randomUUID();
        ModuleRevisionId moduleId = ModuleRevisionId.newInstance((String)"dkpro", (String)uuid.toString(), (String)"working");
        DefaultModuleDescriptor md = DefaultModuleDescriptor.newDefaultInstance((ModuleRevisionId)moduleId);
        DefaultDependencyDescriptor dd = new DefaultDependencyDescriptor((ModuleDescriptor)md, ModuleRevisionId.newInstance((String)aGroupId, (String)aArtifactId, (String)aVersion), false, false, true);
        dd.addDependencyConfiguration("default", "default");
        md.addDependency((DependencyDescriptor)dd);
        try {
            ResolveOptions options = new ResolveOptions();
            if (this.log.isDebugEnabled()) {
                options.setLog("default");
            } else if (this.log.isInfoEnabled()) {
                options.setLog("download-only");
            } else {
                options.setLog("quiet");
            }
            options.setConfs(new String[]{"default"});
            report = ivy.resolve((ModuleDescriptor)md, options);
        }
        finally {
            String resid = ResolveOptions.getDefaultResolveId((ModuleDescriptor)md);
            ivy.getResolutionCacheManager().getResolvedIvyFileInCache(moduleId).delete();
            ivy.getResolutionCacheManager().getResolvedIvyPropertiesInCache(moduleId).delete();
            ivy.getResolutionCacheManager().getConfigurationResolveReportInCache(resid, "default").delete();
        }
        ArrayList<File> files = new ArrayList<File>();
        for (ArtifactDownloadReport rep : report.getAllArtifactsReports()) {
            files.add(rep.getLocalFile());
        }
        return files;
    }

    private IOException handleResolvingError(Throwable aCause, String aLocation, Properties aProps) {
        StringBuilder sb = new StringBuilder();
        Set<String> names = aProps.stringPropertyNames();
        if (names.contains(ARTIFACT_ID) && names.contains(GROUP_ID)) {
            String artifactId = this.pph.replacePlaceholders(aProps.getProperty(ARTIFACT_ID), aProps);
            String groupId = this.pph.replacePlaceholders(aProps.getProperty(GROUP_ID), aProps);
            String version = this.pph.replacePlaceholders(aProps.getProperty(VERSION, ""), aProps);
            String extraErrorInfo = "";
            try {
                version = this.getModelVersionFromMavenPom();
            }
            catch (IOException ex) {
                extraErrorInfo = ExceptionUtils.getRootCauseMessage((Throwable)ex);
            }
            catch (IllegalStateException ex) {
                extraErrorInfo = ExceptionUtils.getRootCauseMessage((Throwable)ex);
            }
            sb.append("\nPlease make sure that [").append(artifactId).append(']');
            if (StringUtils.isNotBlank((String)version)) {
                sb.append(" version [").append(version).append(']');
            }
            sb.append(" is on the classpath.\n");
            if (StringUtils.isNotBlank((String)version)) {
                sb.append("If the version ").append("shown here is not available, try a recent version.\n");
                sb.append('\n');
                sb.append("If you are using Maven, add the following dependency to your pom.xml file:\n");
                sb.append('\n');
                sb.append("<dependency>\n");
                sb.append("  <groupId>").append(groupId).append("</groupId>\n");
                sb.append("  <artifactId>").append(artifactId).append("</artifactId>\n");
                sb.append("  <version>").append(version).append("</version>\n");
                sb.append("</dependency>\n");
            } else {
                sb.append("I was unable to determine which version of the desired model is compatible with this component:\n").append(extraErrorInfo).append("\n");
            }
        }
        if (NOT_REQUIRED.equals(aLocation)) {
            return new IOException("Unable to load resource: \n" + ExceptionUtils.getRootCauseMessage((Throwable)aCause) + "\n" + sb.toString());
        }
        return new IOException("Unable to load resource [" + aLocation + "]: \n" + ExceptionUtils.getRootCauseMessage((Throwable)aCause) + "\n" + sb.toString());
    }

    public M getResource() {
        return this.resource;
    }

    protected Properties getAggregatedProperties() throws IOException {
        Properties defaultValues = new Properties(this.defaults);
        Properties props = this.getProperties();
        if (props != null) {
            defaultValues.putAll((Map<?, ?>)props);
        }
        Properties importedValues = new Properties(defaultValues);
        for (Map.Entry<String, HasResourceMetadata> e : this.imports.entrySet()) {
            String value = e.getValue().getResourceMetaData().getProperty(e.getKey());
            if (value == null) continue;
            importedValues.setProperty(e.getKey(), value);
        }
        Properties overriddenValues = new Properties(importedValues);
        overriddenValues.putAll((Map<?, ?>)this.overrides);
        if (this.defaultVariants == null && this.defaultVariantsLocation != null) {
            String dvl = this.pph.replacePlaceholders(this.defaultVariantsLocation, overriddenValues);
            this.setDefaultVariants(PropertiesLoaderUtils.loadAllProperties((String)dvl));
        }
        String language = overriddenValues.getProperty(LANGUAGE);
        if (this.defaultVariants != null && this.defaultVariants.containsKey(language)) {
            defaultValues.setProperty(VARIANT, this.defaultVariants.getProperty(language));
        }
        return overriddenValues;
    }

    protected abstract Properties getProperties();

    protected abstract M produceResource(URL var1) throws IOException;

    @Override
    public Properties getResourceMetaData() {
        return this.resourceMetaData;
    }

    private void mergeProperties(Properties aTarget, Properties aSource) {
        for (Object key : aSource.keySet()) {
            if (aTarget.containsKey(key)) continue;
            aTarget.put(key, aSource.get(key));
        }
    }

    private static final class ExtensibleURLClassLoader
    extends URLClassLoader {
        public ExtensibleURLClassLoader(ClassLoader aParent) {
            super(new URL[0], aParent);
        }

        @Override
        public void addURL(URL aUrl) {
            super.addURL(aUrl);
        }
    }
}

