/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ngram;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.util.AttributeSource;

public final class EdgeNGramTokenizer
extends Tokenizer {
    public static final Side DEFAULT_SIDE = Side.FRONT;
    public static final int DEFAULT_MAX_GRAM_SIZE = 1;
    public static final int DEFAULT_MIN_GRAM_SIZE = 1;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private int minGram;
    private int maxGram;
    private int gramSize;
    private Side side;
    private boolean started;
    private int inLen;
    private int charsRead;
    private String inStr;

    public EdgeNGramTokenizer(Reader input, Side side, int minGram, int maxGram) {
        super(input);
        this.init(side, minGram, maxGram);
    }

    public EdgeNGramTokenizer(AttributeSource source, Reader input, Side side, int minGram, int maxGram) {
        super(source, input);
        this.init(side, minGram, maxGram);
    }

    public EdgeNGramTokenizer(AttributeSource.AttributeFactory factory, Reader input, Side side, int minGram, int maxGram) {
        super(factory, input);
        this.init(side, minGram, maxGram);
    }

    public EdgeNGramTokenizer(Reader input, String sideLabel, int minGram, int maxGram) {
        this(input, Side.getSide(sideLabel), minGram, maxGram);
    }

    public EdgeNGramTokenizer(AttributeSource source, Reader input, String sideLabel, int minGram, int maxGram) {
        this(source, input, Side.getSide(sideLabel), minGram, maxGram);
    }

    public EdgeNGramTokenizer(AttributeSource.AttributeFactory factory, Reader input, String sideLabel, int minGram, int maxGram) {
        this(factory, input, Side.getSide(sideLabel), minGram, maxGram);
    }

    private void init(Side side, int minGram, int maxGram) {
        if (side == null) {
            throw new IllegalArgumentException("sideLabel must be either front or back");
        }
        if (minGram < 1) {
            throw new IllegalArgumentException("minGram must be greater than zero");
        }
        if (minGram > maxGram) {
            throw new IllegalArgumentException("minGram must not be greater than maxGram");
        }
        this.minGram = minGram;
        this.maxGram = maxGram;
        this.side = side;
    }

    public boolean incrementToken() throws IOException {
        this.clearAttributes();
        if (!this.started) {
            int inc;
            this.started = true;
            this.gramSize = this.minGram;
            char[] chars = new char[1024];
            this.charsRead = 0;
            while (this.charsRead < chars.length && (inc = this.input.read(chars, this.charsRead, chars.length - this.charsRead)) != -1) {
                this.charsRead += inc;
            }
            this.inStr = new String(chars, 0, this.charsRead).trim();
            if (this.charsRead == chars.length) {
                int inc2;
                char[] throwaway = new char[1024];
                while ((inc2 = this.input.read(throwaway, 0, throwaway.length)) != -1) {
                    this.charsRead += inc2;
                }
            }
            this.inLen = this.inStr.length();
            if (this.inLen == 0) {
                return false;
            }
        }
        if (this.gramSize > this.inLen) {
            return false;
        }
        if (this.gramSize > this.maxGram) {
            return false;
        }
        int start = this.side == Side.FRONT ? 0 : this.inLen - this.gramSize;
        int end = start + this.gramSize;
        this.termAtt.setEmpty().append((CharSequence)this.inStr, start, end);
        this.offsetAtt.setOffset(this.correctOffset(start), this.correctOffset(end));
        ++this.gramSize;
        return true;
    }

    public void end() {
        int finalOffset = this.correctOffset(this.charsRead);
        this.offsetAtt.setOffset(finalOffset, finalOffset);
    }

    public void reset() throws IOException {
        super.reset();
        this.started = false;
    }

    public static enum Side {
        FRONT{

            @Override
            public String getLabel() {
                return "front";
            }
        }
        ,
        BACK{

            @Override
            public String getLabel() {
                return "back";
            }
        };


        public abstract String getLabel();

        public static Side getSide(String sideName) {
            if (FRONT.getLabel().equals(sideName)) {
                return FRONT;
            }
            if (BACK.getLabel().equals(sideName)) {
                return BACK;
            }
            return null;
        }
    }
}

