/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.kernel.metric;

import java.util.Map;
import org.apache.ctakes.ytex.kernel.metric.BaseSimilarityMetric;
import org.apache.ctakes.ytex.kernel.metric.ConceptSimilarityService;
import org.apache.ctakes.ytex.kernel.metric.SimilarityInfo;

public class RadaMetric
extends BaseSimilarityMetric {
    double depthMax = 0.0;

    public RadaMetric(ConceptSimilarityService simSvc, Integer depthMax) {
        super(simSvc);
        if (depthMax != null) {
            this.depthMax = depthMax.doubleValue();
        }
    }

    @Override
    public double similarity(String concept1, String concept2, Map<String, Double> conceptFilter, SimilarityInfo simInfo) {
        if (this.depthMax == 0.0) {
            return 0.0;
        }
        this.initLCSes(concept1, concept2, simInfo);
        if (simInfo.getLcsDist() > 0) {
            return 1.0 - ((double)simInfo.getLcsDist().intValue() - 1.0) / (2.0 * this.depthMax);
        }
        return 0.0;
    }
}

