/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.semil;

import com.google.common.collect.BiMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ctakes.ytex.kernel.BaseClassifierEvaluationParser;
import org.apache.ctakes.ytex.kernel.ClassifierEvaluationParser;
import org.apache.ctakes.ytex.kernel.KernelContextHolder;
import org.apache.ctakes.ytex.kernel.model.ClassifierEvaluation;
import org.apache.ctakes.ytex.kernel.model.SemiLClassifierEvaluation;

public class SemiLEvaluationParser
extends BaseClassifierEvaluationParser {
    public static final Log log = LogFactory.getLog(SemiLEvaluationParser.class);
    public static Pattern pGamma = Pattern.compile("gamma=([\\d\\.\\-\\+e]+)");
    public static Pattern pMu = Pattern.compile("mu=([\\d\\.\\-\\+e]+)");
    public static Pattern pLambda = Pattern.compile("lambda=([\\d\\.\\-\\+e]+)");
    public static Pattern pLabel = Pattern.compile("hard_label=([01])");
    public static Pattern pLaplacian = Pattern.compile("Laplacian=([01])");
    public static Pattern pPercent = Pattern.compile("labeled points =([\\d\\.\\-\\+e]+)");
    public static Pattern pOutput = Pattern.compile("dist_(\\w+)_(\\d+)");

    @Override
    public void parseDirectory(File dataDir, File outputDir) throws IOException {
        Properties kernelProps = this.loadProps(outputDir);
        String labelBase = kernelProps.getProperty("kernel.label.basename");
        if (labelBase != null && labelBase.length() > 0) {
            String classFileName = dataDir + File.separator + labelBase.substring(0, labelBase.length() - "label".length()) + "class.txt";
            List<BaseClassifierEvaluationParser.InstanceClassInfo> listClassInfo = super.loadInstanceClassInfo(dataDir, classFileName);
            if (listClassInfo != null) {
                for (File output : outputDir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(".output");
                    }
                })) {
                    this.parseSemiLOutput(dataDir, labelBase, kernelProps, output, listClassInfo);
                }
            }
        } else {
            log.warn((Object)("couldn't parse directory; kernel.label.base not defined. Dir: " + outputDir));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseSemiLOutput(File dataDir, String fileBaseName, Properties kernelProps, File output, List<BaseClassifierEvaluationParser.InstanceClassInfo> listClassInfo) throws IOException {
        BufferedReader outputReader = null;
        try {
            outputReader = new BufferedReader(new FileReader(output));
            String optionsLine = null;
            String predictLine = null;
            while ((optionsLine = outputReader.readLine()) != null && (predictLine = outputReader.readLine()) != null) {
                SemiLClassifierEvaluation ce = new SemiLClassifierEvaluation();
                this.initClassifierEvaluation(fileBaseName, ce);
                this.initClassifierEvaluationFromProperties(kernelProps, ce);
                BiMap<Integer, String> classIdToNameMap = this.loadClassIdMap(dataDir, ce.getLabel());
                this.parseOptions(ce, optionsLine, kernelProps, output.getName());
                boolean storeUnlabeled = "yes".equalsIgnoreCase(kernelProps.getProperty(ClassifierEvaluationParser.ParseOption.STORE_UNLABELED.getOptionKey(), ClassifierEvaluationParser.ParseOption.STORE_UNLABELED.getDefaultValue()));
                this.parsePredictedClasses(ce, predictLine, listClassInfo, storeUnlabeled, classIdToNameMap);
                this.storeSemiSupervised(kernelProps, ce, classIdToNameMap);
            }
        }
        finally {
            if (outputReader != null) {
                try {
                    outputReader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void parsePredictedClasses(ClassifierEvaluation ce, String predictLine, List<BaseClassifierEvaluationParser.InstanceClassInfo> listClassInfo, boolean storeUnlabeled, BiMap<Integer, String> classIdToNameMap) {
        String[] strClassIds = predictLine.split("\\s");
        String[] classNames = new String[strClassIds.length];
        for (int i = 0; i < strClassIds.length; ++i) {
            classNames[i] = (String)classIdToNameMap.get((Object)Integer.parseInt(strClassIds[i]));
        }
        this.updateSemiSupervisedPredictions(ce, listClassInfo, storeUnlabeled, classNames, (Map<String, Integer>)classIdToNameMap.inverse());
    }

    private void parseOptions(SemiLClassifierEvaluation ce, String optionsLine, Properties kernelProps, String outputName) {
        ce.setOptions(optionsLine);
        ce.setGamma(this.parseDoubleOption(pGamma, optionsLine));
        ce.setLambda(this.parseDoubleOption(pLambda, optionsLine));
        ce.setMu(this.parseDoubleOption(pMu, optionsLine));
        ce.setPercentLabeled(this.parseDoubleOption(pPercent, optionsLine));
        ce.setNormalizedLaplacian(this.parseIntOption(pLaplacian, optionsLine) == 1);
        ce.setSoftLabel(this.parseIntOption(pLabel, optionsLine) == 1);
        Matcher mOutput = pOutput.matcher(outputName);
        if (mOutput.find()) {
            ce.setDistance(mOutput.group(1));
            ce.setDegree(Integer.parseInt(mOutput.group(2)));
        }
        ce.setAlgorithm("semiL");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<Integer, Integer> getInstanceIdClass(String labelFile, List<Integer> instanceIds) throws IOException {
        HashMap<Integer, Integer> mapInstanceIdClass = new HashMap<Integer, Integer>(instanceIds.size());
        BufferedReader instanceReader = null;
        try {
            instanceReader = new BufferedReader(new FileReader(labelFile));
            int nLine = 0;
            String instanceLine = null;
            while ((instanceLine = instanceReader.readLine()) != null) {
                mapInstanceIdClass.put(instanceIds.get(nLine), Integer.parseInt(SemiLEvaluationParser.extractFirstToken(instanceLine, wsPattern)));
                ++nLine;
            }
        }
        finally {
            if (instanceReader != null) {
                try {
                    instanceReader.close();
                }
                catch (Exception e) {
                    log.error((Object)labelFile, (Throwable)e);
                }
            }
        }
        return mapInstanceIdClass;
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.out.println("Usage: java " + SemiLEvaluationParser.class.getName() + "dataDir outputDir");
        } else {
            BaseClassifierEvaluationParser parser = (BaseClassifierEvaluationParser)KernelContextHolder.getApplicationContext().getBean(SemiLEvaluationParser.class);
            parser.parseDirectory(new File(args[0]), new File(args[1]));
        }
    }
}

