/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.corpus.conll2005;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.zip.GZIPInputStream;
import org.apache.uima.UimaContext;
import org.apache.uima.cas.CASException;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.component.JCasCollectionReader_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.SofaCapability;
import org.apache.uima.fit.factory.CollectionReaderFactory;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Progress;
import org.apache.uima.util.ProgressImpl;
import org.cleartk.util.ViewUriUtil;

@SofaCapability(outputSofas={"CONLL_2005_VIEW", "UriView"})
public class Conll2005GoldReader
extends JCasCollectionReader_ImplBase {
    @ConfigurationParameter(name="conll2005DataFile", mandatory=true, description="the path of the CoNLL 2005 data file")
    private File conll2005DataFile;
    public static final String PARAM_CONLL2005_DATA_FILE = "conll2005DataFile";
    private BufferedReader reader;
    private boolean finished = false;
    private int documentNumber;
    private int totalDocuments;

    public static CollectionReader getCollectionReader(String conll2005DataFile) throws ResourceInitializationException {
        return CollectionReaderFactory.createReader(Conll2005GoldReader.class, (Object[])new Object[]{PARAM_CONLL2005_DATA_FILE, conll2005DataFile});
    }

    public void initialize(UimaContext context) throws ResourceInitializationException {
        try {
            String line;
            this.reader = this.getBufferedReader();
            this.totalDocuments = 0;
            do {
                line = this.reader.readLine();
                while (line != null && line.trim().length() == 0) {
                    line = this.reader.readLine();
                }
                if (line == null) break;
                ++this.totalDocuments;
                while (line != null && line.trim().length() > 0) {
                    line = this.reader.readLine();
                }
            } while (line != null);
            this.reader.close();
            this.reader = this.getBufferedReader();
            this.documentNumber = 0;
        }
        catch (IOException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    private BufferedReader getBufferedReader() throws IOException {
        InputStream in = this.conll2005DataFile.getName().endsWith(".gz") ? new GZIPInputStream(new FileInputStream(this.conll2005DataFile)) : new FileInputStream(this.conll2005DataFile);
        return new BufferedReader(new InputStreamReader(in));
    }

    public void getNext(JCas jCas) throws IOException, CollectionException {
        try {
            URI uri;
            JCas conllView = jCas.createView("CONLL_2005_VIEW");
            StringBuffer docBuffer = new StringBuffer();
            String lineBuffer = this.reader.readLine();
            while (lineBuffer != null && lineBuffer.trim().length() == 0) {
                lineBuffer = this.reader.readLine();
            }
            if (lineBuffer == null) {
                throw new CollectionException("unexpected end of input", null);
            }
            while (lineBuffer != null && lineBuffer.trim().length() != 0) {
                docBuffer.append(lineBuffer.trim());
                docBuffer.append("\n");
                lineBuffer = this.reader.readLine();
            }
            ++this.documentNumber;
            if (this.documentNumber == this.totalDocuments) {
                this.finished = true;
            }
            conllView.setSofaDataString(docBuffer.toString(), "text/plain");
            URI fileURI = this.conll2005DataFile.toURI();
            String fragment = String.valueOf(this.documentNumber);
            try {
                uri = new URI(fileURI.getScheme(), fileURI.getHost(), fileURI.getPath(), fragment);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            ViewUriUtil.setURI((JCas)jCas, (URI)uri);
        }
        catch (CASException e) {
            throw new CollectionException((Throwable)e);
        }
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public Progress[] getProgress() {
        return new Progress[]{new ProgressImpl(this.documentNumber, this.totalDocuments, "entities")};
    }

    public boolean hasNext() throws IOException, CollectionException {
        return !this.finished;
    }
}

