/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.corpus.genia.pos.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.cleartk.corpus.genia.pos.util.Span;

public class GeniaTag {
    String label;
    List<Span> spans;

    public GeniaTag(String label, List<Span> spans) {
        this.label = label;
        this.spans = new ArrayList<Span>();
        this.setSpans(spans);
    }

    public GeniaTag(String label, Span span) {
        this.label = label;
        this.spans = new ArrayList<Span>();
        this.setSpans(Collections.singletonList(span));
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public List<Span> getSpans() {
        return Collections.unmodifiableList(this.spans);
    }

    public void setSpans(List<Span> spans) {
        this.spans.clear();
        if (spans.size() <= 1) {
            this.spans.addAll(spans);
        } else {
            this.spans.add(spans.get(0));
            for (int i = 1; i < spans.size(); ++i) {
                Span span = spans.get(i);
                Span previousSpan = this.spans.get(this.spans.size() - 1);
                if (previousSpan.getEnd() + 1 == span.getBegin()) {
                    this.spans.remove(this.spans.size() - 1);
                    this.spans.add(new Span(previousSpan.getBegin(), span.getEnd()));
                    continue;
                }
                this.spans.add(span);
            }
        }
    }
}

