/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.corpus.penntreebank;

import com.google.common.annotations.Beta;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

@Beta
public class RangeSpecification
implements Iterable<Integer> {
    private int start;
    private int end;
    private SortedSet<Integer> numbers = new TreeSet<Integer>();

    public RangeSpecification(String spec) {
        String[] parts = spec.trim().split("-");
        if (parts.length == 2) {
            this.start = Integer.valueOf(parts[0]);
            this.end = Integer.valueOf(parts[1]);
        } else if (parts.length == 1) {
            this.start = this.end = Integer.valueOf(parts[0]).intValue();
        } else {
            throw new IllegalArgumentException();
        }
        for (int i = this.start; i <= this.end; ++i) {
            this.numbers.add(i);
        }
    }

    public boolean contains(int i) {
        return this.numbers.contains(i);
    }

    public String toString() {
        if (this.start == this.end) {
            return String.valueOf(this.start);
        }
        return String.valueOf(this.start) + "-" + String.valueOf(this.end);
    }

    @Override
    public Iterator<Integer> iterator() {
        return this.numbers.iterator();
    }
}

