/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.corpus.penntreebank;

import java.util.List;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.SofaCapability;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.corpus.penntreebank.TreebankNodeConverter;
import org.cleartk.syntax.constituent.type.TerminalTreebankNode;
import org.cleartk.syntax.constituent.type.TopTreebankNode;
import org.cleartk.token.type.Sentence;
import org.cleartk.token.type.Token;
import org.cleartk.util.treebank.TreebankFormatParser;

@SofaCapability(inputSofas={"TREEBANK_VIEW", "_InitialView"}, outputSofas={})
public class TreebankGoldAnnotator
extends JCasAnnotator_ImplBase {
    public static final String PARAM_POST_TREES = "postTrees";
    private static final String POST_TREES_DESCRIPTION = "specifies whether or not to post trees (i.e. annotations of type TreebankNode) to the CAS.  Sometimes treebank data is used only for the part-of-speech data that it contains.  For such uses, it is not necessary to post the entire constituent parse to the CAS. Instead, this parameter can be set to false which results in  only the part-of-speech data being added.";
    @ConfigurationParameter(name="postTrees", description="specifies whether or not to post trees (i.e. annotations of type TreebankNode) to the CAS.  Sometimes treebank data is used only for the part-of-speech data that it contains.  For such uses, it is not necessary to post the entire constituent parse to the CAS. Instead, this parameter can be set to false which results in  only the part-of-speech data being added.", mandatory=false, defaultValue={"true"})
    private boolean postTrees;

    public static AnalysisEngineDescription getDescription() throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(TreebankGoldAnnotator.class, (Object[])new Object[0]);
    }

    public static AnalysisEngineDescription getDescriptionPOSTagsOnly() throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(TreebankGoldAnnotator.class, (Object[])new Object[]{PARAM_POST_TREES, false});
    }

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        String tbText;
        JCas docView;
        try {
            docView = jCas.getView("_InitialView");
            tbText = jCas.getView("TREEBANK_VIEW").getDocumentText();
        }
        catch (CASException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        String docText = docView.getDocumentText();
        if (docText == null) {
            docText = TreebankFormatParser.inferPlainText((String)tbText);
            docView.setSofaDataString(docText, "text/plain");
        }
        List topNodes = TreebankFormatParser.parseDocument((String)tbText, (int)0, (String)docText);
        for (org.cleartk.util.treebank.TopTreebankNode topNode : topNodes) {
            TopTreebankNode uimaNode = TreebankNodeConverter.convert(topNode, docView, this.postTrees);
            Sentence uimaSentence = new Sentence(docView, uimaNode.getBegin(), uimaNode.getEnd());
            uimaSentence.addToIndexes();
            int tokenIndex = 0;
            for (TerminalTreebankNode terminal : JCasUtil.select((FSArray)uimaNode.getTerminals(), TerminalTreebankNode.class)) {
                if (terminal.getBegin() != terminal.getEnd()) {
                    terminal.setTokenIndex(tokenIndex++);
                    Token uimaToken = new Token(docView, terminal.getBegin(), terminal.getEnd());
                    uimaToken.setPos(terminal.getNodeType());
                    uimaToken.addToIndexes();
                    continue;
                }
                terminal.setTokenIndex(-1);
            }
        }
    }
}

