/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.feature.extractor;

import java.util.Collections;
import java.util.List;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.Feature;
import org.cleartk.ml.feature.extractor.FeatureExtractor2;
import org.cleartk.util.AnnotationUtil;

public class DirectedDistanceExtractor<T extends Annotation, U extends Annotation>
implements FeatureExtractor2<T, U> {
    String name;
    Class<? extends Annotation> unitClass;

    public DirectedDistanceExtractor(String name, Class<? extends Annotation> unitClass) {
        this.name = name;
        this.unitClass = unitClass;
    }

    @Override
    public List<Feature> extract(JCas jCas, Annotation annotation1, Annotation annotation2) {
        Annotation secondAnnotation;
        Annotation firstAnnotation;
        String featureName = Feature.createName(this.name, "DDistance", this.unitClass.getSimpleName());
        boolean negate = false;
        if (annotation1.getBegin() <= annotation2.getBegin()) {
            firstAnnotation = annotation1;
            secondAnnotation = annotation2;
        } else {
            firstAnnotation = annotation2;
            secondAnnotation = annotation1;
            negate = true;
        }
        int featureValue = 0;
        if (AnnotationUtil.overlaps((Annotation)annotation1, (Annotation)annotation2)) {
            featureValue = 0;
        } else {
            List annotations = JCasUtil.selectCovered((JCas)jCas, this.unitClass, (int)firstAnnotation.getEnd(), (int)secondAnnotation.getBegin());
            featureValue = annotations.size() + 1;
        }
        if (negate) {
            featureValue = -featureValue;
        }
        return Collections.singletonList(new Feature(featureName, featureValue));
    }
}

