/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Set;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.typesystem.type.refsem.Event;
import org.apache.ctakes.typesystem.type.refsem.EventProperties;
import org.apache.ctakes.typesystem.type.relation.RelationArgument;
import org.apache.ctakes.typesystem.type.relation.TemporalTextRelation;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.util.ViewUriUtil;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

@PipeBitInfo(name="I2B2 XML Reader (THYME)", description="Reads annotations from THYME schema I2B2 XML files in a directory.", role=PipeBitInfo.Role.SPECIAL, products={PipeBitInfo.TypeProduct.EVENT, PipeBitInfo.TypeProduct.TEMPORAL_RELATION})
public class I2B2TemporalXMLReader
extends JCasAnnotator_ImplBase {
    public static final String PARAM_INPUT_DIR = "PARAM_INPUT_DIR";
    @ConfigurationParameter(name="PARAM_INPUT_DIR", mandatory=true, description="Directory containing i2b2 files to read")
    protected File inputDir;
    public static final String PARAM_MAP_THYME = "PARAM_MAP_THYME";
    @ConfigurationParameter(name="PARAM_MAP_THYME", mandatory=false, description="Whether to map i2b2 relations/properties/types to THYME types")
    protected boolean mapThyme = false;
    private static final Set<String> beforeSet = Sets.newHashSet((Object[])new String[]{"BEFORE", "ENDED_BY", "BEFORE_OVERLAP"});
    private static final Set<String> afterSet = Sets.newHashSet((Object[])new String[]{"BEGUN_BY", "AFTER"});

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        int end;
        int begin;
        Element dataElem;
        File textFile = new File(ViewUriUtil.getURI((JCas)jcas));
        File xmlFile = new File(textFile.getAbsolutePath().substring(0, textFile.getAbsolutePath().length() - 4));
        HashMap<String, Object> id2entity = new HashMap<String, Object>();
        try {
            dataElem = new SAXBuilder().build(xmlFile.toURI().toURL()).getRootElement();
        }
        catch (MalformedURLException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        catch (JDOMException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        for (Element timexEl : dataElem.getChild("TAGS").getChildren("TIMEX3")) {
            begin = Integer.parseInt(timexEl.getAttributeValue("start")) - 1;
            end = Integer.parseInt(timexEl.getAttributeValue("end")) - 1;
            String timeClass = timexEl.getAttributeValue("type");
            TimeMention timex = new TimeMention(jcas, begin, end);
            id2entity.put(timexEl.getAttributeValue("id"), timex);
            timex.setTimeClass(timeClass);
            timex.addToIndexes();
        }
        for (Element eventEl : dataElem.getChild("TAGS").getChildren("EVENT")) {
            begin = Integer.parseInt(eventEl.getAttributeValue("start")) - 1;
            end = Integer.parseInt(eventEl.getAttributeValue("end")) - 1;
            Event e = new Event(jcas);
            EventProperties props = new EventProperties(jcas);
            EventMention event = new EventMention(jcas, begin, end);
            id2entity.put(eventEl.getAttributeValue("id"), event);
            String polarity = eventEl.getAttributeValue("polarity");
            if (polarity.equals("POS")) {
                event.setPolarity(1);
            } else if (polarity.equals("NEG")) {
                event.setPolarity(-1);
            }
            String modality = eventEl.getAttributeValue("modality");
            if (this.mapThyme) {
                if (modality.equals("FACTUAL")) {
                    props.setContextualModality("ACTUAL");
                } else if (modality.equals("POSSIBLE")) {
                    props.setContextualModality("HEDGED");
                } else if (modality.equals("HYPOTHETICAL") || modality.equals("CONDITIONAL")) {
                    props.setContextualModality("HYPOTHETICAL");
                } else if (modality.equals("PROPOSED")) {
                    props.setContextualModality("GENERIC");
                }
            } else {
                props.setContextualModality(modality);
            }
            e.setProperties(props);
            FSArray mentions = new FSArray(jcas, 1);
            mentions.set(0, (FeatureStructure)event);
            e.setMentions(mentions);
            event.setEvent(e);
            e.addToIndexes();
            event.addToIndexes();
            props.addToIndexes();
        }
        for (Element linkEl : dataElem.getChild("TAGS").getChildren("TLINK")) {
            Annotation fromEnt = (Annotation)id2entity.get(linkEl.getAttributeValue("fromID"));
            Annotation toEnt = (Annotation)id2entity.get(linkEl.getAttributeValue("toID"));
            String cat = linkEl.getAttributeValue("type");
            TemporalTextRelation link = new TemporalTextRelation(jcas);
            RelationArgument arg1 = new RelationArgument(jcas);
            arg1.setArgument(fromEnt);
            link.setArg1(arg1);
            RelationArgument arg2 = new RelationArgument(jcas);
            arg2.setArgument(toEnt);
            link.setArg2(arg2);
            if (this.mapThyme) {
                throw new UnsupportedOperationException("Mapping to THYME relations is not implemented yet!");
            }
            if (beforeSet.contains(cat)) {
                link.setCategory("BEFORE");
            } else if (afterSet.contains(cat)) {
                link.setCategory("AFTER");
            } else {
                link.setCategory("OVERLAP");
            }
            link.addToIndexes();
            arg1.addToIndexes();
            arg2.addToIndexes();
        }
    }

    public static AnalysisEngineDescription getDescription(File xmlDirectory) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(I2B2TemporalXMLReader.class, (Object[])new Object[]{PARAM_INPUT_DIR, xmlDirectory});
    }
}

