/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae.feature;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.ctakes.typesystem.type.syntax.ConllDependencyNode;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

public class DependencyParseUtils {
    public static List<LinkedList<ConllDependencyNode>> getPathsToCommonAncestor(ConllDependencyNode node1, ConllDependencyNode node2) {
        ArrayList<LinkedList<ConllDependencyNode>> paths = new ArrayList<LinkedList<ConllDependencyNode>>(2);
        LinkedList<ConllDependencyNode> node1ToHeadPath = DependencyParseUtils.getPathToSentenceHead(node1);
        LinkedList<ConllDependencyNode> node2ToHeadPath = DependencyParseUtils.getPathToSentenceHead(node2);
        ConllDependencyNode ancestor = null;
        while (!node1ToHeadPath.isEmpty() && !node2ToHeadPath.isEmpty() && node1ToHeadPath.getLast() == node2ToHeadPath.getLast()) {
            node1ToHeadPath.removeLast();
            ancestor = node2ToHeadPath.removeLast();
        }
        if (ancestor != null) {
            node1ToHeadPath.add(ancestor);
            node2ToHeadPath.add(ancestor);
        }
        paths.add(node1ToHeadPath);
        paths.add(node2ToHeadPath);
        return paths;
    }

    public static ConllDependencyNode getCommonAncestor(ConllDependencyNode node1, ConllDependencyNode node2) {
        LinkedList<ConllDependencyNode> node1ToHeadPath = DependencyParseUtils.getPathToSentenceHead(node1);
        LinkedList<ConllDependencyNode> node2ToHeadPath = DependencyParseUtils.getPathToSentenceHead(node2);
        ConllDependencyNode ancestor = null;
        while (!node1ToHeadPath.isEmpty() && !node2ToHeadPath.isEmpty() && node1ToHeadPath.getLast() == node2ToHeadPath.getLast()) {
            node1ToHeadPath.removeLast();
            ancestor = node2ToHeadPath.removeLast();
        }
        return ancestor;
    }

    public static ConllDependencyNode findAnnotationHead(JCas jcas, Annotation annotation) {
        for (ConllDependencyNode depNode : JCasUtil.selectCovered((JCas)jcas, ConllDependencyNode.class, (AnnotationFS)annotation)) {
            ConllDependencyNode head = depNode.getHead();
            if (head != null && head.getHead() != null && head.getEnd() > annotation.getBegin() && head.getBegin() <= annotation.getEnd()) continue;
            return depNode;
        }
        return null;
    }

    public static LinkedList<ConllDependencyNode> getPathToSentenceHead(ConllDependencyNode node) {
        LinkedList<ConllDependencyNode> path = new LinkedList<ConllDependencyNode>();
        ConllDependencyNode currNode = node;
        while (currNode.getHead() != null) {
            path.add(currNode);
            currNode = currNode.getHead();
        }
        return path;
    }

    public static LinkedList<ConllDependencyNode> getPathBetweenNodes(ConllDependencyNode srcNode, ConllDependencyNode tgtNode) {
        LinkedList<ConllDependencyNode> path = new LinkedList<ConllDependencyNode>();
        List<LinkedList<ConllDependencyNode>> paths = DependencyParseUtils.getPathsToCommonAncestor(srcNode, tgtNode);
        LinkedList<ConllDependencyNode> srcToAncestorPath = paths.get(0);
        LinkedList<ConllDependencyNode> tgtToAncestorPath = paths.get(1);
        if (srcNode == tgtNode) {
            return path;
        }
        if (!srcToAncestorPath.isEmpty()) {
            srcToAncestorPath.removeLast();
        }
        path = srcToAncestorPath;
        while (!tgtToAncestorPath.isEmpty()) {
            path.add(tgtToAncestorPath.removeLast());
        }
        return path;
    }

    public static String pathToString(LinkedList<ConllDependencyNode> path) {
        StringBuilder builder = new StringBuilder();
        for (ConllDependencyNode node : path) {
            if (node != path.getFirst() && node != path.getLast()) {
                builder.append(node.getPostag());
                builder.append("-");
            }
            builder.append(node.getDeprel());
            if (node == path.getLast()) continue;
            builder.append("/");
        }
        return builder.toString();
    }

    public static String dumpDependencyRelations(JCas jcas, Annotation annotation) {
        StringBuilder builder = new StringBuilder();
        for (ConllDependencyNode depNode : JCasUtil.selectCovered((JCas)jcas, ConllDependencyNode.class, (AnnotationFS)annotation)) {
            if (depNode.getHead() == null) continue;
            builder.append(String.format("%s(%s,%s)\n", depNode.getDeprel(), depNode.getCoveredText(), depNode.getHead().getCoveredText()));
        }
        return builder.toString();
    }
}

