/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae.feature;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.typesystem.type.relation.BinaryTextRelation;
import org.apache.ctakes.typesystem.type.syntax.TreebankNode;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.Feature;

public class ListFeaturesExtractor
implements RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation> {
    public List<Feature> extract(JCas jCas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2) throws AnalysisEngineProcessException {
        ArrayList feats = Lists.newArrayList();
        feats.addAll(ListFeaturesExtractor.getArgFeats(jCas, arg1, arg2, "Arg1"));
        feats.addAll(ListFeaturesExtractor.getArgFeats(jCas, arg2, arg2, "Arg2"));
        return feats;
    }

    private static Collection<? extends Feature> getArgFeats(JCas jCas, IdentifiedAnnotation primeArg, IdentifiedAnnotation secondArg, String prefix) {
        TreebankNode node;
        ArrayList feats = Lists.newArrayList();
        List nodes = JCasUtil.selectCovered(TreebankNode.class, (AnnotationFS)primeArg);
        if (nodes.size() > 0 && (node = (TreebankNode)nodes.get(0)).getBegin() == primeArg.getBegin() && node.getEnd() == primeArg.getEnd()) {
            TreebankNode parent;
            HashSet<String> priorNPs = new HashSet<String>();
            if (node.getNodeType().startsWith("NN")) {
                node = node.getParent();
            }
            if ((parent = node.getParent()) == null) {
                return feats;
            }
            int childIndex = -1;
            for (int i = 0; i < parent.getChildren().size(); ++i) {
                if (parent.getChildren(i) == node) {
                    childIndex = i;
                    break;
                }
                priorNPs.add(ListFeaturesExtractor.getKey((Annotation)parent.getChildren(i)));
            }
            boolean lcComma = false;
            boolean rcComma = false;
            boolean lcAnd = false;
            if (node.getNodeType().equals("NP") && parent.getNodeType().equals("NP")) {
                if (childIndex > 0 && parent.getChildren(childIndex - 1).getNodeType().equals(",")) {
                    lcComma = true;
                }
                if (childIndex + 1 < parent.getChildren().size() && parent.getChildren(childIndex + 1).getNodeType().equals(",")) {
                    rcComma = true;
                }
                if (childIndex + 1 == parent.getChildren().size() && childIndex > 0 && parent.getChildren(childIndex - 1).getNodeType().equals("CC")) {
                    lcAnd = true;
                }
            }
            if (lcComma && rcComma) {
                feats.add(new Feature(prefix + "_midlist", (Object)true));
            } else if (childIndex == 0 && rcComma) {
                feats.add(new Feature(prefix + "_startlist", (Object)true));
            } else if (lcAnd) {
                feats.add(new Feature(prefix + "_endlist", (Object)true));
            }
            if (lcComma || rcComma || lcAnd) {
                for (BinaryTextRelation otherRel : JCasUtil.select((JCas)jCas, BinaryTextRelation.class)) {
                    Annotation a1 = otherRel.getArg1().getArgument();
                    Annotation a2 = otherRel.getArg2().getArgument();
                    if (a1 instanceof TimeMention || a2 instanceof TimeMention) continue;
                    if (priorNPs.contains(ListFeaturesExtractor.getKey(a1))) {
                        feats.add(new Feature(prefix + "_leftSiblingInRelation", (Object)true));
                        if (secondArg.getBegin() == a2.getBegin() && secondArg.getEnd() == a2.getEnd()) {
                            feats.add(new Feature((Object)(prefix + "_leftSiblingInRelationWithCurArg")));
                        }
                    }
                    if (!priorNPs.contains(ListFeaturesExtractor.getKey(a2))) continue;
                    feats.add(new Feature(prefix + "_leftSiblingInRelation", (Object)true));
                    if (secondArg.getBegin() != a1.getBegin() || secondArg.getEnd() != a1.getEnd()) continue;
                    feats.add(new Feature((Object)(prefix + "_leftSiblingInRelationWithCurArg")));
                }
            }
        }
        return feats;
    }

    private static String getKey(Annotation annot) {
        return annot.getBegin() + "-" + annot.getEnd();
    }
}

