/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae.feature;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textspan.Segment;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.cleartk.ml.Feature;

public class SectionHeaderRelationExtractor
implements RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation> {
    public List<Feature> extract(JCas jcas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2) throws AnalysisEngineProcessException {
        Feature feature;
        String segname;
        ArrayList<Feature> feats = new ArrayList<Feature>();
        EventMention eventA = null;
        EventMention eventB = null;
        if (arg1 instanceof EventMention) {
            eventA = (EventMention)arg1;
        }
        if (arg2 instanceof EventMention) {
            eventB = (EventMention)arg2;
        }
        if (eventA == null && eventB == null) {
            return feats;
        }
        Map coveringMap = JCasUtil.indexCovering((JCas)jcas, EventMention.class, Segment.class);
        ArrayList segListA = Lists.newArrayList();
        ArrayList segListB = Lists.newArrayList();
        if (eventA != null) {
            for (Segment seg : (Collection)coveringMap.get(eventA)) {
                if (seg.getId().equals("SIMPLE_SEGMENT")) continue;
                segListA.add(seg);
            }
        }
        if (eventB != null) {
            for (Segment seg : (Collection)coveringMap.get(eventB)) {
                if (seg.getId().equals("SIMPLE_SEGMENT")) continue;
                segListB.add(seg);
            }
        }
        ArrayList segANames = Lists.newArrayList();
        ArrayList segBNames = Lists.newArrayList();
        for (Segment seg : segListA) {
            segname = seg.getId();
            feature = new Feature("SegmentID_arg1", (Object)segname);
            feats.add(feature);
            segANames.add(segname);
        }
        for (Segment seg : segListB) {
            segname = seg.getId();
            feature = new Feature("SegmentID_arg2", (Object)segname);
            feats.add(feature);
            segBNames.add(segname);
        }
        for (String segA : segANames) {
            for (String segB : segBNames) {
                if (!segA.equals(segB)) continue;
                Feature feature2 = new Feature("InTheSameSegment_", (Object)segA);
                feats.add(feature2);
            }
        }
        return feats;
    }
}

