/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae.feature.treekernel;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.ctakes.utils.tree.SimpleTree;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.cleartk.ml.Feature;
import org.cleartk.ml.TreeFeature;

public class EventTimeFlatTreeFeatureExtractor
implements RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation> {
    public List<Feature> extract(JCas jcas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2) throws AnalysisEngineProcessException {
        ArrayList<Feature> feats = new ArrayList<Feature>();
        if (arg1.getBegin() > arg2.getBegin()) {
            IdentifiedAnnotation temp = arg1;
            arg1 = arg2;
            arg2 = temp;
        }
        SimpleTree bopTree = EventTimeFlatTreeFeatureExtractor.getTree(jcas, arg1, arg2, "BOP", new Function<BaseToken, String>(){

            public String apply(BaseToken t) {
                return t.getPartOfSpeech();
            }
        });
        SimpleTree bowTree = EventTimeFlatTreeFeatureExtractor.getTree(jcas, arg1, arg2, "BOW", new Function<BaseToken, String>(){

            public String apply(BaseToken t) {
                return t.getCoveredText();
            }
        });
        feats.add((Feature)new TreeFeature("TK_BOP_Tree", (Object)bopTree.toString()));
        feats.add((Feature)new TreeFeature("TK_BOW_Tree", (Object)bowTree.toString()));
        return feats;
    }

    private static SimpleTree getTree(JCas jcas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2, String label, Function<BaseToken, String> leafFun) throws AnalysisEngineProcessException {
        EventMention mention;
        SimpleTree tree = new SimpleTree(label);
        SimpleTree arg1Tree = null;
        SimpleTree arg2Tree = null;
        String eventModality = "";
        String timeClass = "";
        if (arg1 instanceof EventMention) {
            mention = (EventMention)arg1;
            if (mention.getEvent() != null && mention.getEvent().getProperties() != null) {
                eventModality = mention.getEvent().getProperties().getContextualModality();
            }
            arg1Tree = new SimpleTree("EVENT-" + eventModality);
        } else if (arg1 instanceof TimeMention) {
            timeClass = ((TimeMention)arg1).getTimeClass();
            arg1Tree = new SimpleTree("TIMEX-" + timeClass);
        } else {
            throw new AnalysisEngineProcessException("Argument type not recognized (arg1) -- must be EventMention or TimeMention", null);
        }
        if (arg2 instanceof EventMention) {
            mention = (EventMention)arg2;
            if (mention.getEvent() != null && mention.getEvent().getProperties() != null) {
                eventModality = mention.getEvent().getProperties().getContextualModality();
            }
            arg2Tree = new SimpleTree("EVENT-" + eventModality);
        } else if (arg2 instanceof TimeMention) {
            timeClass = ((TimeMention)arg2).getTimeClass();
            arg2Tree = new SimpleTree("TIMEX-" + timeClass);
        } else {
            throw new AnalysisEngineProcessException("Argument type not recognized (arg2) -- must be EventMention or TimeMention", null);
        }
        List tokens = JCasUtil.selectCovered((JCas)jcas, BaseToken.class, (int)arg1.getBegin(), (int)arg2.getEnd());
        tree.addChild(arg1Tree);
        for (BaseToken token : tokens) {
            SimpleTree tokenTree = new SimpleTree("TOK");
            tokenTree.addChild(new SimpleTree((String)leafFun.apply((Object)token)));
            if (token.getEnd() <= arg1.getEnd()) {
                arg1Tree.addChild(tokenTree);
                continue;
            }
            if (token.getBegin() >= arg2.getBegin()) {
                arg2Tree.addChild(tokenTree);
                continue;
            }
            tree.addChild(tokenTree);
        }
        tree.addChild(arg2Tree);
        return tree;
    }
}

