/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.eval;

import com.google.common.base.Function;
import com.lexicalscope.jewel.cli.CliFactory;
import com.lexicalscope.jewel.cli.Option;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.apache.ctakes.relationextractor.eval.RelationExtractorEvaluation;
import org.apache.ctakes.temporal.ae.ClearTKLinkToTHYMELinkAnnotator;
import org.apache.ctakes.temporal.ae.EventToClearTKEventAnnotator;
import org.apache.ctakes.temporal.ae.TimexToClearTKTimexAnnotator;
import org.apache.ctakes.temporal.eval.EvaluationOfEventTimeRelations;
import org.apache.ctakes.temporal.eval.EvaluationOfTemporalRelations_ImplBase;
import org.apache.ctakes.temporal.eval.Evaluation_ImplBase;
import org.apache.ctakes.typesystem.type.relation.BinaryTextRelation;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.factory.AggregateBuilder;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.pipeline.JCasIterator;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.cleartk.eval.AnnotationStatistics;
import org.cleartk.opennlp.tools.ParserAnnotator;
import org.cleartk.opennlp.tools.PosTaggerAnnotator;
import org.cleartk.opennlp.tools.SentenceAnnotator;
import org.cleartk.snowball.DefaultSnowballStemmer;
import org.cleartk.timeml.event.EventAspectAnnotator;
import org.cleartk.timeml.event.EventClassAnnotator;
import org.cleartk.timeml.event.EventModalityAnnotator;
import org.cleartk.timeml.event.EventPolarityAnnotator;
import org.cleartk.timeml.event.EventTenseAnnotator;
import org.cleartk.timeml.time.TimeTypeAnnotator;
import org.cleartk.timeml.tlink.TemporalLinkEventToSameSentenceTimeAnnotator;
import org.cleartk.timeml.tlink.TemporalLinkEventToSubordinatedEventAnnotator;
import org.cleartk.token.tokenizer.TokenAnnotator;

public class EvaluationOfClearTKRelations
extends EvaluationOfTemporalRelations_ImplBase {
    private boolean doEventEvent = true;
    private boolean doEventTime = true;

    public static void main(String[] args) throws Exception {
        EvalOptions options = (EvalOptions)CliFactory.parseArguments(EvalOptions.class, (String[])args);
        if (options.getIgnoreEventEvent() && options.getIgnoreEventTime()) {
            System.err.println("Ignoring all relation types is not a valid configuration.");
            System.exit(-1);
        }
        List<Integer> patientSets = options.getPatients().getList();
        List<Integer> trainItems = EvaluationOfClearTKRelations.getTrainItems(options);
        List<Integer> testItems = EvaluationOfClearTKRelations.getTestItems(options);
        EvaluationOfClearTKRelations evaluation = new EvaluationOfClearTKRelations(new File("target/eval/cleartk-event-time-links"), options.getRawTextDirectory(), options.getXMLDirectory(), options.getXMLFormat(), options.getSubcorpus(), options.getXMIDirectory());
        evaluation.setExtractEventEvent(!options.getIgnoreEventEvent());
        evaluation.setExtractEventTime(!options.getIgnoreEventTime());
        evaluation.prepareXMIsFor(patientSets);
        AnnotationStatistics stats = (AnnotationStatistics)evaluation.trainAndTest(trainItems, testItems);
        System.err.println(stats);
    }

    public EvaluationOfClearTKRelations(File baseDirectory, File rawTextDirectory, File xmlDirectory, Evaluation_ImplBase.XMLFormat xmlFormat, Evaluation_ImplBase.Subcorpus subcorpus, File xmiDirectory) {
        super(baseDirectory, rawTextDirectory, xmlDirectory, xmlFormat, subcorpus, xmiDirectory, null, false, false, defaultParams);
    }

    private void setExtractEventTime(boolean eventTime) {
        this.doEventTime = eventTime;
    }

    private void setExtractEventEvent(boolean eventEvent) {
        this.doEventEvent = eventEvent;
    }

    protected void train(CollectionReader collectionReader, File directory) throws Exception {
    }

    protected AnnotationStatistics<String> test(CollectionReader collectionReader, File directory) throws Exception {
        AggregateBuilder aggregateBuilder = this.getPreprocessorAggregateBuilder();
        aggregateBuilder.add(Evaluation_ImplBase.CopyFromGold.getDescription(EventMention.class, TimeMention.class), new String[0]);
        aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(EvaluationOfEventTimeRelations.RemoveCrossSentenceRelations.class, (Object[])new Object[]{"SentenceView", "_InitialView", "RelationView", "GoldView"}), new String[0]);
        if (!this.doEventEvent) {
            aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(EvaluationOfEventTimeRelations.RemoveEventEventRelations.class, (Object[])new Object[0]), new String[]{"_InitialView", "GoldView"});
        }
        if (!this.doEventTime) {
            aggregateBuilder.add(AnalysisEngineFactory.createEngineDescription(EvaluationOfTemporalRelations_ImplBase.PreserveEventEventRelations.class, (Object[])new Object[0]), new String[]{"_InitialView", "GoldView"});
        }
        aggregateBuilder.add(SentenceAnnotator.getDescription(), new String[0]);
        aggregateBuilder.add(TokenAnnotator.getDescription(), new String[0]);
        aggregateBuilder.add(PosTaggerAnnotator.getDescription(), new String[0]);
        aggregateBuilder.add(DefaultSnowballStemmer.getDescription((String)"English"), new String[0]);
        aggregateBuilder.add(ParserAnnotator.getDescription(), new String[0]);
        aggregateBuilder.add(EventToClearTKEventAnnotator.getAnnotatorDescription(), new String[0]);
        aggregateBuilder.add(TimexToClearTKTimexAnnotator.getAnnotatorDescription(), new String[0]);
        aggregateBuilder.add(EventTenseAnnotator.FACTORY.getAnnotatorDescription("/org/cleartk/timeml/event/eventtenseannotator/model.jar"), new String[0]);
        aggregateBuilder.add(EventAspectAnnotator.FACTORY.getAnnotatorDescription("/org/cleartk/timeml/event/eventaspectannotator/model.jar"), new String[0]);
        aggregateBuilder.add(EventClassAnnotator.FACTORY.getAnnotatorDescription("/org/cleartk/timeml/event/eventclassannotator/model.jar"), new String[0]);
        aggregateBuilder.add(EventPolarityAnnotator.FACTORY.getAnnotatorDescription("/org/cleartk/timeml/event/eventpolarityannotator/model.jar"), new String[0]);
        aggregateBuilder.add(EventModalityAnnotator.FACTORY.getAnnotatorDescription("/org/cleartk/timeml/event/eventmodalityannotator/model.jar"), new String[0]);
        aggregateBuilder.add(TimeTypeAnnotator.FACTORY.getAnnotatorDescription("/org/cleartk/timeml/time/timetypeannotator/model.jar"), new String[0]);
        if (this.doEventTime) {
            aggregateBuilder.add(TemporalLinkEventToSameSentenceTimeAnnotator.FACTORY.getAnnotatorDescription("/org/cleartk/timeml/tlink/temporallinkeventtosamesentencetimeannotator/model.jar"), new String[0]);
        }
        if (this.doEventEvent) {
            aggregateBuilder.add(TemporalLinkEventToSubordinatedEventAnnotator.FACTORY.getAnnotatorDescription("/org/cleartk/timeml/tlink/temporallinkeventtosubordinatedeventannotator/model.jar"), new String[0]);
        }
        aggregateBuilder.add(ClearTKLinkToTHYMELinkAnnotator.getAnnotatorDescription(), new String[0]);
        Function<BinaryTextRelation, RelationExtractorEvaluation.HashableArguments> getSpan = new Function<BinaryTextRelation, RelationExtractorEvaluation.HashableArguments>(){

            public RelationExtractorEvaluation.HashableArguments apply(BinaryTextRelation relation) {
                return new RelationExtractorEvaluation.HashableArguments(relation);
            }
        };
        Function getOutcome = AnnotationStatistics.annotationToFeatureValue((String)"category");
        AnnotationStatistics stats = new AnnotationStatistics();
        JCasIterator casIter = new JCasIterator(collectionReader, new AnalysisEngine[]{aggregateBuilder.createAggregate()});
        while (casIter.hasNext()) {
            JCas jCas = (JCas)casIter.next();
            JCas goldView = jCas.getView("GoldView");
            JCas systemView = jCas.getView("_InitialView");
            Collection goldRelations = JCasUtil.select((JCas)goldView, BinaryTextRelation.class);
            Collection systemRelations = JCasUtil.select((JCas)systemView, BinaryTextRelation.class);
            stats.add(goldRelations, systemRelations, (Function)getSpan, getOutcome);
        }
        return stats;
    }

    static interface EvalOptions
    extends Evaluation_ImplBase.Options {
        @Option(longName={"iee"})
        public boolean getIgnoreEventEvent();

        @Option(longName={"iet"})
        public boolean getIgnoreEventTime();
    }
}

