/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.nn.ae;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.temporal.ae.TemporalRelationExtractorAnnotator;
import org.apache.ctakes.temporal.nn.data.ArgContextProvider;
import org.apache.ctakes.typesystem.type.relation.BinaryTextRelation;
import org.apache.ctakes.typesystem.type.relation.RelationArgument;
import org.apache.ctakes.typesystem.type.relation.TemporalTextRelation;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.CleartkAnnotator;
import org.cleartk.ml.Feature;
import org.cleartk.ml.Instance;
import org.cleartk.util.ViewUriUtil;

@PipeBitInfo(name="E-E POS TLinker", description="Creates Event - Event TLinks with Parts of Speech.", dependencies={PipeBitInfo.TypeProduct.SECTION, PipeBitInfo.TypeProduct.SENTENCE, PipeBitInfo.TypeProduct.EVENT}, products={PipeBitInfo.TypeProduct.TEMPORAL_RELATION})
public class EventEventPosBasedAnnotator
extends CleartkAnnotator<String> {
    public static final String NO_RELATION_CATEGORY = "none";

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        HashMap<List<Annotation>, BinaryTextRelation> relationLookup = new HashMap<List<Annotation>, BinaryTextRelation>();
        if (this.isTraining()) {
            relationLookup = new HashMap();
            for (BinaryTextRelation relation : JCasUtil.select((JCas)jCas, BinaryTextRelation.class)) {
                Annotation arg2;
                Annotation arg1 = relation.getArg1().getArgument();
                List<Annotation> key = Arrays.asList(arg1, arg2 = relation.getArg2().getArgument());
                if (relationLookup.containsKey(key)) {
                    String reln = ((BinaryTextRelation)relationLookup.get(key)).getCategory();
                    System.err.println("Error in: " + ViewUriUtil.getURI((JCas)jCas).toString());
                    System.err.println("Error! This attempted relation " + relation.getCategory() + " already has a relation " + reln + " at this span: " + arg1.getCoveredText() + " -- " + arg2.getCoveredText());
                    continue;
                }
                relationLookup.put(key, relation);
            }
        }
        for (Sentence sentence : JCasUtil.select((JCas)jCas, Sentence.class)) {
            List<TemporalRelationExtractorAnnotator.IdentifiedAnnotationPair> candidatePairs = EventEventPosBasedAnnotator.getCandidateRelationArgumentPairs(jCas, sentence);
            for (TemporalRelationExtractorAnnotator.IdentifiedAnnotationPair pair : candidatePairs) {
                String[] tokens;
                String context;
                IdentifiedAnnotation arg1 = pair.getArg1();
                IdentifiedAnnotation arg2 = pair.getArg2();
                if (arg2.getBegin() < arg1.getBegin()) {
                    System.out.println("\n-------------- THIS NEVER NAPPENS ------------\n");
                    context = ArgContextProvider.getPosContext(jCas, sentence, (Annotation)arg2, "e2", (Annotation)arg1, "e1", 2);
                } else {
                    context = ArgContextProvider.getPosContext(jCas, sentence, (Annotation)arg1, "e1", (Annotation)arg2, "e2", 2);
                }
                ArrayList<Feature> feats = new ArrayList<Feature>();
                for (String token : tokens = context.split(" ")) {
                    feats.add(new Feature((Object)token.toLowerCase()));
                }
                if (this.isTraining()) {
                    String category = this.getRelationCategory(relationLookup, arg1, arg2);
                    category = category == null ? NO_RELATION_CATEGORY : category.toLowerCase();
                    this.dataWriter.write(new Instance((Object)category, feats));
                    continue;
                }
                String predictedCategory = (String)this.classifier.classify(feats);
                if (predictedCategory == null || predictedCategory.equals(NO_RELATION_CATEGORY)) continue;
                if (predictedCategory.endsWith("-1")) {
                    predictedCategory = predictedCategory.substring(0, predictedCategory.length() - 2);
                    IdentifiedAnnotation temp = arg1;
                    arg1 = arg2;
                    arg2 = temp;
                }
                this.createRelation(jCas, arg1, arg2, predictedCategory.toUpperCase(), 0.0);
            }
        }
    }

    protected String getRelationCategory(Map<List<Annotation>, BinaryTextRelation> relationLookup, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2) {
        BinaryTextRelation relation = relationLookup.get(Arrays.asList(arg1, arg2));
        String category = null;
        if (relation != null) {
            category = arg2.getBegin() < arg1.getBegin() ? relation.getCategory() + "-1" : relation.getCategory();
        } else {
            relation = relationLookup.get(Arrays.asList(arg2, arg1));
            if (relation != null) {
                category = arg2.getBegin() < arg1.getBegin() ? relation.getCategory() : relation.getCategory() + "-1";
            }
        }
        return category;
    }

    protected String getRelationCategory2(Map<List<Annotation>, BinaryTextRelation> relationLookup, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2) {
        BinaryTextRelation arg1ContainsArg2 = relationLookup.get(Arrays.asList(arg1, arg2));
        BinaryTextRelation arg2ContainsArg1 = relationLookup.get(Arrays.asList(arg2, arg1));
        if (arg1ContainsArg2 != null) {
            if (arg1.getBegin() < arg2.getBegin()) {
                return arg1ContainsArg2.getCategory();
            }
            return arg1ContainsArg2.getCategory() + "-1";
        }
        if (arg2ContainsArg1 != null) {
            if (arg1.getBegin() < arg2.getBegin()) {
                return arg2ContainsArg1.getCategory() + "-1";
            }
            return arg2ContainsArg1.getCategory();
        }
        return null;
    }

    protected void createRelation(JCas jCas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2, String predictedCategory, double confidence) {
        RelationArgument relArg1 = new RelationArgument(jCas);
        relArg1.setArgument((Annotation)arg1);
        relArg1.setRole("Arg1");
        relArg1.addToIndexes();
        RelationArgument relArg2 = new RelationArgument(jCas);
        relArg2.setArgument((Annotation)arg2);
        relArg2.setRole("Arg2");
        relArg2.addToIndexes();
        TemporalTextRelation relation = new TemporalTextRelation(jCas);
        relation.setArg1(relArg1);
        relation.setArg2(relArg2);
        relation.setCategory(predictedCategory);
        relation.setConfidence(confidence);
        relation.addToIndexes();
    }

    private static List<TemporalRelationExtractorAnnotator.IdentifiedAnnotationPair> getCandidateRelationArgumentPairs(JCas jCas, Sentence sentence) {
        ArrayList pairs = Lists.newArrayList();
        ArrayList events = new ArrayList(JCasUtil.selectCovered((JCas)jCas, EventMention.class, (AnnotationFS)sentence));
        ArrayList realEvents = Lists.newArrayList();
        for (EventMention event : events) {
            if (!event.getClass().equals(EventMention.class)) continue;
            realEvents.add(event);
        }
        events = realEvents;
        int eventNum = events.size();
        for (int i = 0; i < eventNum - 1; ++i) {
            for (int j = i + 1; j < eventNum; ++j) {
                EventMention eventA = (EventMention)events.get(i);
                EventMention eventB = (EventMention)events.get(j);
                pairs.add(new TemporalRelationExtractorAnnotator.IdentifiedAnnotationPair((IdentifiedAnnotation)eventA, (IdentifiedAnnotation)eventB));
            }
        }
        return pairs;
    }
}

