/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.pipelines;

import com.lexicalscope.jewel.cli.CliFactory;
import com.lexicalscope.jewel.cli.Option;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.ctakes.relationextractor.eval.XMIReader;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.factory.CollectionReaderFactory;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

public class EventPrintingPipeline {
    public static void main(String[] args) throws Exception {
        Options options = (Options)CliFactory.parseArguments(Options.class, (String[])args);
        SimplePipeline.runPipeline((CollectionReader)EventPrintingPipeline.getCollectionReader(Arrays.asList(options.getInputDirectory().listFiles())), (AnalysisEngine[])new AnalysisEngine[]{PrintEventAnnotations.getDescription()});
    }

    private static CollectionReader getCollectionReader(List<File> items) throws Exception {
        String[] paths = new String[items.size()];
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = items.get(i).getPath();
        }
        return CollectionReaderFactory.createReader(XMIReader.class, (Object[])new Object[]{"files", paths});
    }

    public static class PrintEventAnnotations
    extends JCasAnnotator_ImplBase {
        public static AnalysisEngine getDescription() throws ResourceInitializationException {
            return AnalysisEngineFactory.createEngine(PrintEventAnnotations.class, (Object[])new Object[0]);
        }

        public void process(JCas jCas) throws AnalysisEngineProcessException {
            for (EventMention eventMention : JCasUtil.select((JCas)jCas, EventMention.class)) {
                if (!eventMention.getClass().getSimpleName().equals("EventMention")) continue;
                List sentences = JCasUtil.selectCovering((JCas)jCas, Sentence.class, (int)eventMention.getBegin(), (int)eventMention.getEnd());
                System.out.println(eventMention.getCoveredText() + "|" + ((Sentence)sentences.get(0)).getCoveredText());
            }
        }
    }

    static interface Options {
        @Option(shortName={"i"}, description="specify the path to the directory containing xmi files containing event annotations")
        public File getInputDirectory();
    }
}

