/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.ctakes.temporal.utils.AnnotationIdCollection;
import org.apache.ctakes.temporal.utils.TlinkType;
import org.apache.ctakes.temporal.utils.TlinkTypeSet;
import org.apache.ctakes.typesystem.type.relation.BinaryTextRelation;
import org.apache.ctakes.typesystem.type.relation.RelationArgument;
import org.apache.ctakes.typesystem.type.relation.TemporalTextRelation;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

public class TLinkTypeArray2 {
    private final TlinkTypeSet[][] _tlinkTypesArray;
    private final AnnotationIdCollection _entityIdCollection;
    private final List<Integer> _entityIdList;

    private static TlinkTypeSet getTlinkTypesAtoC(TlinkTypeSet tlinkTypesAtoB, TlinkTypeSet tlinkTypesBtoC) {
        if (tlinkTypesAtoB == null || tlinkTypesBtoC == null || tlinkTypesAtoB.isEmpty() || tlinkTypesBtoC.isEmpty()) {
            return null;
        }
        TlinkTypeSet tlinkTypeSetAtoC = new TlinkTypeSet();
        for (TlinkType tlinkTypeAtoB : tlinkTypesAtoB) {
            for (TlinkType tlinkTypeBtoC : tlinkTypesBtoC) {
                TlinkType tertiary = tlinkTypeAtoB.getTimeRelationTypeAtoC(tlinkTypeBtoC);
                if (tertiary == null) continue;
                tlinkTypeSetAtoC.add(tertiary);
            }
        }
        return tlinkTypeSetAtoC;
    }

    public TLinkTypeArray2(List<BinaryTextRelation> tlinkList, AnnotationIdCollection entityIdCollection) {
        HashSet<Integer> tlinkAnnotationIds = new HashSet<Integer>();
        for (BinaryTextRelation tlink : tlinkList) {
            tlinkAnnotationIds.add(entityIdCollection.getAnnotationId(tlink.getArg1().getArgument()));
            tlinkAnnotationIds.add(entityIdCollection.getAnnotationId(tlink.getArg2().getArgument()));
        }
        this._entityIdList = new ArrayList<Integer>(tlinkAnnotationIds);
        Collections.sort(this._entityIdList);
        int entityCount = this._entityIdList.size();
        this._tlinkTypesArray = new TlinkTypeSet[entityCount][entityCount];
        this._entityIdCollection = entityIdCollection;
        this.populateTlinkTypesArray(tlinkList);
    }

    public TlinkTypeSet getTlinkTypes(BinaryTextRelation tlink) {
        Annotation entityA = tlink.getArg1().getArgument();
        Annotation entityB = tlink.getArg2().getArgument();
        int entityIdA = this._entityIdCollection.getAnnotationId(entityA);
        int entityIdB = this._entityIdCollection.getAnnotationId(entityB);
        int indexA = this._entityIdList.indexOf(entityIdA);
        int indexB = this._entityIdList.indexOf(entityIdB);
        return this.getTlinkTypes(indexA, indexB);
    }

    public List<BinaryTextRelation> getClosedTlinks(JCas jCas) {
        int length = this.getAnnotationIdCount();
        if (length == 0) {
            return Collections.emptyList();
        }
        ArrayList<BinaryTextRelation> closedTlinks = new ArrayList<BinaryTextRelation>();
        for (int row = 0; row < length; ++row) {
            for (int column = 0; column < length; ++column) {
                TlinkTypeSet tlinkTypeSet;
                if (row == column || (tlinkTypeSet = this._tlinkTypesArray[row][column]) == null || tlinkTypeSet.isEmpty()) continue;
                for (TlinkType tlinkType : tlinkTypeSet) {
                    BinaryTextRelation tlink = this.createTlink(jCas, row, column, tlinkType);
                    if (tlink == null) continue;
                    closedTlinks.add(tlink);
                }
            }
        }
        return closedTlinks;
    }

    private BinaryTextRelation createTlink(JCas jCas, int row, int column, TlinkType tlinkType) {
        Annotation entityA = this.getAnnotation(row);
        Annotation entityB = this.getAnnotation(column);
        if (entityA == null || entityB == null) {
            return null;
        }
        RelationArgument arg1 = new RelationArgument(jCas);
        arg1.setArgument(entityA);
        RelationArgument arg2 = new RelationArgument(jCas);
        arg2.setArgument(entityB);
        TemporalTextRelation relation = new TemporalTextRelation(jCas);
        relation.setArg1(arg1);
        relation.setArg2(arg2);
        relation.setCategory(tlinkType.name().replace("_", "-"));
        return relation;
    }

    private int getAnnotationId(int index) {
        return this._entityIdList.get(index);
    }

    private Annotation getAnnotation(int index) {
        int entityId = this.getAnnotationId(index);
        return this._entityIdCollection.getAnnotation(entityId);
    }

    private void populateTlinkTypesArray(List<BinaryTextRelation> tlinkList) {
        int explicitCount = 0;
        for (BinaryTextRelation tlink : tlinkList) {
            if (!this.addTlinkType(tlink)) continue;
            explicitCount += 2;
        }
        int entityIdCount = this.getAnnotationIdCount();
        int inferredInIteration = -1;
        int iterations = 0;
        int totalInferred = 0;
        while (inferredInIteration != 0) {
            inferredInIteration = 0;
            for (int index = 0; index < entityIdCount; ++index) {
                inferredInIteration += this.inferForIndex(index);
            }
            totalInferred += inferredInIteration;
            ++iterations;
        }
        int tlinkCount = 0;
        for (int i = 0; i < entityIdCount; ++i) {
            for (int j = 0; j < entityIdCount; ++j) {
                if (this._tlinkTypesArray[i][j] == null) continue;
                tlinkCount += this._tlinkTypesArray[i][j].size();
            }
        }
        System.out.println("===================================================================================");
        System.out.println("   Marked Entities: " + entityIdCount + ", Marked TLinks: " + tlinkList.size() + ", Proper TLinks: " + explicitCount + ", Inferred TLinks: " + totalInferred + ", Total TLinks: " + tlinkCount + ", Iterations: " + iterations);
        System.out.println("===================================================================================");
    }

    private int inferForIndex(int indexA) {
        int entityIdCount = this.getAnnotationIdCount();
        int inferredCount = 0;
        for (int indexB = 0; indexB < entityIdCount; ++indexB) {
            TlinkTypeSet tlinkTypesAtoB;
            if (indexA == indexB || (tlinkTypesAtoB = this.getTlinkTypes(indexA, indexB)) == null) continue;
            for (int indexC = 0; indexC < entityIdCount; ++indexC) {
                TlinkTypeSet tlinkTypesBtoC;
                if (indexC == indexA || indexC == indexB || (tlinkTypesBtoC = this.getTlinkTypes(indexB, indexC)) == null) continue;
                inferredCount += this.inferTlinkTypesForIndexAtoBtoC(indexA, indexB, indexC, tlinkTypesAtoB, tlinkTypesBtoC);
                if (!this.hasTlinkType(indexA, indexB, TlinkType.OVERLAP)) {
                    inferredCount += this.inferTlinkTypesForAnnotationAtoBwithCandD(indexA, indexB, indexC, TlinkType.OVERLAP);
                }
                if (this.hasTlinkType(indexA, indexB, TlinkType.CONTAINS)) continue;
                inferredCount += this.inferTlinkTypesForAnnotationAtoBwithCandD(indexA, indexB, indexC, TlinkType.CONTAINS);
            }
        }
        return inferredCount;
    }

    private int inferTlinkTypesForIndexAtoBtoC(int indexA, int indexB, int indexC, TlinkTypeSet tlinkTypesAtoB, TlinkTypeSet tlinkTypesBtoC) {
        int addedCount = 0;
        TlinkTypeSet tlinkTypesAtoC = TLinkTypeArray2.getTlinkTypesAtoC(tlinkTypesAtoB, tlinkTypesBtoC);
        return addedCount += this.addTlinkTypes(indexA, indexC, tlinkTypesAtoC);
    }

    private int inferTlinkTypesForAnnotationAtoBwithCandD(int indexA, int indexB, int indexC, TlinkType tlinkType) {
        int entityCount = this.getAnnotationIdCount();
        int addedCount = 0;
        if (this.hasTlinkType(indexA, indexC, tlinkType)) {
            for (int indexD = 0; indexD < entityCount; ++indexD) {
                if (indexD == indexA || indexD == indexB || indexD == indexC || !this.hasTlinkType(indexA, indexD, tlinkType) || !this.hasTlinkType(indexB, indexC, TlinkType.AFTER) && !this.hasTlinkType(indexB, indexC, TlinkType.BEGINS_ON) || !this.hasTlinkType(indexB, indexD, TlinkType.BEFORE) && !this.hasTlinkType(indexB, indexD, TlinkType.ENDS_ON) || !this.addTlinkType(indexA, indexB, tlinkType)) continue;
                ++addedCount;
            }
        }
        return addedCount;
    }

    private boolean isIndexOk(int entityIndex) {
        return entityIndex >= 0 && entityIndex < this.getAnnotationIdCount();
    }

    private int getAnnotationIdCount() {
        return this._entityIdList.size();
    }

    private boolean hasTlinkType(int indexA, int indexB, TlinkType tlinkType) {
        if (indexA == indexB) {
            return false;
        }
        TlinkTypeSet tlinkTypes = this.getTlinkTypes(indexA, indexB);
        return tlinkTypes != null && tlinkTypes.contains(tlinkType);
    }

    private TlinkTypeSet getTlinkTypes(int indexA, int indexB) {
        if (indexA == indexB || !this.isIndexOk(indexA) || !this.isIndexOk(indexB)) {
            return null;
        }
        return this._tlinkTypesArray[indexA][indexB];
    }

    private int addTlinkTypes(int indexA, int indexC, TlinkTypeSet tlinkTypes) {
        if (tlinkTypes == null || tlinkTypes.isEmpty() || !this.isIndexOk(indexA) || !this.isIndexOk(indexC)) {
            return 0;
        }
        if (this._tlinkTypesArray[indexA][indexC] == null) {
            this._tlinkTypesArray[indexA][indexC] = tlinkTypes;
            this._tlinkTypesArray[indexC][indexA] = tlinkTypes.createReciprocals();
            return 2;
        }
        int addedCount = 0;
        if (this._tlinkTypesArray[indexC][indexA] == null) {
            this._tlinkTypesArray[indexC][indexA] = new TlinkTypeSet();
        }
        for (TlinkType tlinkType : tlinkTypes) {
            boolean added = this._tlinkTypesArray[indexA][indexC].add(tlinkType);
            if (added) {
                ++addedCount;
            }
            if (!(added = this._tlinkTypesArray[indexC][indexA].add(tlinkType.getReciprocal()))) continue;
            ++addedCount;
        }
        return addedCount;
    }

    private boolean addTlinkType(BinaryTextRelation tlink) {
        TlinkType tlinkType = TlinkType.getTlinkType(tlink);
        if (tlinkType == null) {
            return false;
        }
        boolean added1 = this.addTlinkType(tlink.getArg1().getArgument(), tlink.getArg2().getArgument(), tlinkType);
        boolean added2 = this.addTlinkType(tlink.getArg2().getArgument(), tlink.getArg1().getArgument(), tlinkType.getReciprocal());
        return added1 || added2;
    }

    private boolean addTlinkType(Annotation entityA, Annotation entityB, TlinkType tlinkType) {
        int entityIdA = this._entityIdCollection.getAnnotationId(entityA);
        int entityIdB = this._entityIdCollection.getAnnotationId(entityB);
        return this.addTlinkType(entityIdA, entityIdB, tlinkType);
    }

    private boolean addTlinkType(int entityIdA, int entityIdB, TlinkType tlinkType) {
        int indexA = this._entityIdList.indexOf(entityIdA);
        int indexB = this._entityIdList.indexOf(entityIdB);
        if (tlinkType == null || !this.isIndexOk(indexA) || !this.isIndexOk(indexB)) {
            return false;
        }
        if (this._tlinkTypesArray[indexA][indexB] == null) {
            this._tlinkTypesArray[indexA][indexB] = new TlinkTypeSet();
        }
        return this._tlinkTypesArray[indexA][indexB].add(tlinkType);
    }
}

