/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.mallet.factory;

import cc.mallet.classify.ClassifierTrainer;
import cc.mallet.classify.MaxEnt;
import cc.mallet.classify.MaxEntTrainer;
import org.cleartk.ml.mallet.factory.ClassifierTrainerFactory;

public class MaxEntTrainerFactory
implements ClassifierTrainerFactory<MaxEnt> {
    public static final String NAME = "MaxEnt";

    @Override
    public ClassifierTrainer<MaxEnt> createTrainer(String ... args) {
        MaxEntTrainer trainer = new MaxEntTrainer();
        if (args != null) {
            if (args.length % 2 != 0) {
                throw new IllegalArgumentException("each argument must be supplied with a value:  " + this.getUsageMessage());
            }
            for (int i = 0; i < args.length; i += 2) {
                String optionName = args[i];
                String optionValue = args[i + 1];
                if (optionName.equals("--numIterations")) {
                    int numIterations = Integer.parseInt(optionValue);
                    if (numIterations > 0) {
                        trainer.setNumIterations(numIterations);
                        continue;
                    }
                    throw new IllegalArgumentException("numIterations must be positive.  " + this.getUsageMessage());
                }
                if (optionName.equals("--gaussianPriorVariance")) {
                    trainer.setGaussianPriorVariance(Double.parseDouble(optionValue));
                    continue;
                }
                throw new IllegalArgumentException(String.format("the argument %1$s is invalid.  ", optionName) + this.getUsageMessage());
            }
        }
        return trainer;
    }

    @Override
    public String getUsageMessage() {
        return "The arguments for MaxEntTrainerFactory.createTrainer(String...args) should be either empty or include any of the following:\n--numIterations int\n --gaussianPriorVariance double";
    }
}

