/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Db;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.EuiComparator;
import gov.nih.nlm.nls.lvg.Db.EuiRecord;
import gov.nih.nlm.nls.lvg.Db.EuiVector;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Vector;

public class DbEui {
    public static Vector<EuiRecord> GetEuisByInflectedTerm(String ifTerm, Connection conn) throws SQLException {
        String query = "SELECT eui, termCat, termInfl FROM Inflection WHERE ifTermLC = ?";
        PreparedStatement ps = conn.prepareStatement(query);
        ps.setString(1, ifTerm.toLowerCase());
        Vector<EuiRecord> out = DbEui.GetEuisByPreparedStatement(ps);
        return out;
    }

    public static Vector<EuiRecord> GetEuisByUnflectedTerm(String unTerm, Connection conn) throws SQLException {
        String query = "SELECT eui, termCat, termInfl FROM Inflection WHERE unTermLC = ?";
        PreparedStatement ps = conn.prepareStatement(query);
        ps.setString(1, unTerm.toLowerCase());
        Vector<EuiRecord> out = DbEui.GetEuisByPreparedStatement(ps);
        return out;
    }

    public static String GetEuisByUnflectedTermCat(String unTerm, int category, Connection conn) throws SQLException {
        String query = "SELECT eui, termCat, termInfl FROM Inflection WHERE unTermLC = '" + DbBase.FormatSqlStr(unTerm.toLowerCase()) + "' AND termCat = " + category;
        Vector<EuiRecord> out = DbEui.GetEuis(query, conn);
        String outString = new String();
        if (out.size() == 0) {
            outString = "No EUI found";
        } else {
            for (int i = 0; i < out.size(); ++i) {
                outString = outString + out.elementAt(i).GetEui() + ",";
            }
        }
        return outString.substring(0, outString.length() - 1);
    }

    public static void main(String[] args) {
        String testStr = "color";
        if (args.length == 1) {
            testStr = args[0];
        }
        Configuration conf = new Configuration("data.config.lvg", true);
        try {
            Connection conn = DbBase.OpenConnection(conf);
            if (conn != null) {
                Vector<EuiRecord> euiList = DbEui.GetEuisByInflectedTerm(testStr, conn);
                System.out.println("----- Input term: " + testStr);
                System.out.println("-- Number of Inflected Eui: " + euiList.size());
                for (int i = 0; i < euiList.size(); ++i) {
                    System.out.println(i + ". EUI: " + euiList.elementAt(i).GetEui());
                }
                Vector<EuiRecord> euiList1 = DbEui.GetEuisByUnflectedTerm(testStr, conn);
                System.out.println("-- Number of UnInflected Eui: " + euiList1.size());
                for (int i = 0; i < euiList1.size(); ++i) {
                    System.out.println(i + ". EUI: " + euiList1.elementAt(i).GetEui());
                }
                String euiList2 = DbEui.GetEuisByUnflectedTermCat(testStr, 128, conn);
                System.out.println("EUI: " + euiList2);
                DbBase.CloseConnection(conn, conf);
            }
        }
        catch (SQLException sqle) {
            System.err.println(sqle.getMessage());
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    private static Vector<EuiRecord> GetEuis(String query, Connection conn) throws SQLException {
        EuiVector<EuiRecord> euis = new EuiVector<EuiRecord>();
        Statement statement = conn.createStatement();
        ResultSet rs = statement.executeQuery(query);
        while (rs.next()) {
            EuiRecord eui = new EuiRecord();
            eui.SetEui(rs.getString(1));
            eui.SetCategory(rs.getInt(2));
            eui.SetInflection(rs.getLong(3));
            euis.Add(eui);
        }
        rs.close();
        statement.close();
        EuiComparator ec = new EuiComparator();
        Collections.sort(euis, ec);
        return euis;
    }

    private static Vector<EuiRecord> GetEuisByPreparedStatement(PreparedStatement ps) throws SQLException {
        EuiVector<EuiRecord> euis = new EuiVector<EuiRecord>();
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            EuiRecord eui = new EuiRecord();
            eui.SetEui(rs.getString(1));
            eui.SetCategory(rs.getInt(2));
            eui.SetInflection(rs.getLong(3));
            euis.Add(eui);
        }
        rs.close();
        ps.close();
        EuiComparator ec = new EuiComparator();
        Collections.sort(euis, ec);
        return euis;
    }
}

