/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Trie;

import java.util.Arrays;
import java.util.HashSet;

public final class RWildCard {
    public static final char BEGIN = '^';
    public static final char END = '$';
    public static final char CHARACTER = 'C';
    public static final char DIGIT = 'D';
    public static final char LETTER = 'L';
    public static final char SPACE = 'S';
    public static final char PUNCTUATION = 'P';
    private static final HashSet<String> WILD_CARD_SET = new HashSet<String>(Arrays.asList(new Character('^').toString(), new Character('$').toString(), new Character('C').toString(), new Character('D').toString(), new Character('L').toString(), new Character('S').toString(), new Character('P').toString()));
    private static final HashSet<String> PUNCTUATION_SET = new HashSet<String>(Arrays.asList("-", "(", ","));

    public static boolean IsMatchKey(char key, int index, char[] inCharArray) {
        boolean matchFlag = false;
        if (!Character.isLowerCase(key) && !RWildCard.IsWildCardKey(key)) {
            return false;
        }
        if (index < 0) {
            return key == '^';
        }
        char inChar = Character.toLowerCase(inCharArray[index]);
        String inStr = String.valueOf(inChar);
        if (key == inChar) {
            matchFlag = true;
        } else if (key == 'C' && inStr != null) {
            matchFlag = true;
        } else if (key == 'D' && Character.isDigit(inChar)) {
            matchFlag = true;
        } else if (key == 'L' && Character.isLetter(inChar)) {
            matchFlag = true;
        } else if (key == 'S' && inChar == ' ') {
            matchFlag = true;
        } else if (key == 'P' && PUNCTUATION_SET.contains(inStr)) {
            matchFlag = true;
        }
        return matchFlag;
    }

    private static boolean IsWildCardKey(char inChar) {
        String inStr = String.valueOf(inChar);
        return WILD_CARD_SET.contains(inStr);
    }
}

