/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.uima.annotators;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.ytex.uima.ApplicationContextHolder;
import org.apache.ctakes.ytex.uima.mapper.DocumentMapperService;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.cas.impl.XmiCasSerializer;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.XMLSerializer;
import org.xml.sax.SAXException;

@PipeBitInfo(name="XMI Writer 3", description="Writes XMI files with full representation of input text and all extracted information.", role=PipeBitInfo.Role.WRITER, dependencies={PipeBitInfo.TypeProduct.DOCUMENT_ID})
public class DBConsumer
extends JCasAnnotator_ImplBase {
    private static final Log log = LogFactory.getLog(DBConsumer.class);
    private DocumentMapperService documentMapperService;
    private String xmiOutputDirectory;
    private String analysisBatch;
    private boolean bStoreDocText;
    private boolean bStoreCAS;
    private boolean bInsertAnnotationContainmentLinks;
    private Set<String> setTypesToIgnore = new HashSet<String>();

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.xmiOutputDirectory = (String)aContext.getConfigParameterValue("xmiOutputDirectory");
        this.analysisBatch = (String)aContext.getConfigParameterValue("analysisBatch");
        Boolean boolStoreDocText = (Boolean)aContext.getConfigParameterValue("storeDocText");
        Boolean boolStoreCAS = (Boolean)aContext.getConfigParameterValue("storeCAS");
        Boolean boolInsertAnnotationContainmentLinks = (Boolean)aContext.getConfigParameterValue("insertAnnotationContainmentLinks");
        String[] typesToIgnore = (String[])aContext.getConfigParameterValue("typesToIgnore");
        if (typesToIgnore != null) {
            this.setTypesToIgnore.addAll(Arrays.asList(typesToIgnore));
        }
        this.bStoreDocText = boolStoreDocText == null ? true : boolStoreDocText;
        this.bStoreCAS = boolStoreCAS == null ? true : boolStoreCAS;
        this.bInsertAnnotationContainmentLinks = boolInsertAnnotationContainmentLinks == null ? true : boolInsertAnnotationContainmentLinks;
        this.documentMapperService = (DocumentMapperService)ApplicationContextHolder.getApplicationContext().getBean("documentMapperService");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(JCas jcas) {
        Integer documentID = this.documentMapperService.saveDocument(jcas, this.analysisBatch, this.bStoreDocText, this.bStoreCAS, this.bInsertAnnotationContainmentLinks, this.setTypesToIgnore);
        if (documentID != null && this.xmiOutputDirectory != null && this.xmiOutputDirectory.length() > 0) {
            File dirOut = new File(this.xmiOutputDirectory);
            if (!dirOut.exists() && !dirOut.isDirectory()) {
                log.error((Object)(this.xmiOutputDirectory + " does not exist"));
            } else {
                BufferedWriter writer = null;
                try {
                    writer = new BufferedWriter(new FileWriter(this.xmiOutputDirectory + File.separatorChar + documentID.toString() + ".xmi"));
                    XmiCasSerializer ser = new XmiCasSerializer(jcas.getTypeSystem());
                    XMLSerializer xmlSer = new XMLSerializer((Writer)writer, false);
                    ser.serialize(jcas.getCas(), xmlSer.getContentHandler());
                }
                catch (IOException e) {
                    log.error((Object)("error writing xmi, documentID=" + documentID), (Throwable)e);
                }
                catch (SAXException e) {
                    log.error((Object)("error writing xmi, documentID=" + documentID), (Throwable)e);
                }
                finally {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        }
    }
}

