/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dictionary.lookup2.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.apache.ctakes.core.util.DotLogger;
import org.apache.ctakes.utils.env.EnvironmentVariable;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;

public enum UmlsUserApprover {
    INSTANCE;

    public static final String URL_PARAM = "umlsUrl";
    public static final String VENDOR_PARAM = "umlsVendor";
    public static final String USER_PARAM = "umlsUser";
    public static final String PASS_PARAM = "umlsPass";
    private static final String UMLSADDR_PARAM = "ctakes.umlsaddr";
    private static final String UMLSVENDOR_PARAM = "ctakes.umlsvendor";
    static final String UMLSUSER_PARAM = "ctakes.umlsuser";
    static final String UMLSPW_PARAM = "ctakes.umlspw";
    private static final Logger LOGGER;
    private static final String CHANGEME = "CHANGEME";
    private static final Collection<String> _validUsers;

    public static UmlsUserApprover getInstance() {
        return INSTANCE;
    }

    public boolean isValidUMLSUser(UimaContext uimaContext, Properties properties) {
        String pass;
        String user;
        String vendor;
        String umlsUrl = EnvironmentVariable.getEnv((String)UMLSADDR_PARAM, (UimaContext)uimaContext);
        if (umlsUrl == null || umlsUrl.equals(EnvironmentVariable.NOT_PRESENT)) {
            umlsUrl = properties.getProperty(URL_PARAM);
        }
        if ((vendor = EnvironmentVariable.getEnv((String)UMLSVENDOR_PARAM, (UimaContext)uimaContext)) == null || vendor.equals(EnvironmentVariable.NOT_PRESENT)) {
            vendor = properties.getProperty(VENDOR_PARAM);
        }
        if ((user = EnvironmentVariable.getEnv((String)UMLSUSER_PARAM, (UimaContext)uimaContext)) == null || user.equals(EnvironmentVariable.NOT_PRESENT)) {
            user = properties.getProperty(USER_PARAM);
        }
        if ((pass = EnvironmentVariable.getEnv((String)UMLSPW_PARAM, (UimaContext)uimaContext)) == null || pass.equals(EnvironmentVariable.NOT_PRESENT)) {
            pass = properties.getProperty(PASS_PARAM);
        }
        return this.isValidUMLSUser(umlsUrl, vendor, user, pass);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isValidUMLSUser(String umlsUrl, String vendor, String user, String pass) {
        String data;
        String cacheCode = umlsUrl + vendor + user + pass;
        if (_validUsers.contains(cacheCode)) {
            return true;
        }
        try {
            data = URLEncoder.encode("licenseCode", "UTF-8") + "=" + URLEncoder.encode(vendor, "UTF-8");
            data = data + "&" + URLEncoder.encode("user", "UTF-8") + "=" + URLEncoder.encode(user, "UTF-8");
            data = data + "&" + URLEncoder.encode("password", "UTF-8") + "=" + URLEncoder.encode(pass, "UTF-8");
        }
        catch (UnsupportedEncodingException unseE) {
            LOGGER.error((Object)("Could not encode URL for " + user + " with vendor license " + vendor));
            return false;
        }
        if (user.equals(CHANGEME)) {
            LOGGER.info((Object)("Not checking UMLS Account for user " + user + ":"));
            LOGGER.error((Object)"  User CHANGEME not allowed, verify you are setting umlsUser or ctakes.umlsuser properly.");
            return false;
        }
        if (pass.equals(CHANGEME)) {
            LOGGER.info((Object)("Not checking UMLS Account for user " + user + " password " + pass));
            LOGGER.error((Object)"  Password CHANGEME not allowed, verify you are setting umlsPass or ctakes.umlspw properly.");
            return false;
        }
        try (DotLogger dotter = new DotLogger();){
            String trimline;
            String line;
            LOGGER.info((Object)("Checking UMLS Account at " + umlsUrl + " for user " + user + ":"));
            URL url = new URL(umlsUrl);
            URLConnection connection = url.openConnection();
            connection.setDoOutput(true);
            OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream());
            writer.write(data);
            writer.flush();
            boolean isValidUser = false;
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((line = reader.readLine()) != null && !(trimline = line.trim()).isEmpty()) {
                isValidUser = trimline.equalsIgnoreCase("<Result>true</Result>") || trimline.equalsIgnoreCase("<?xml version='1.0' encoding='UTF-8'?><Result>true</Result>");
            }
            writer.close();
            reader.close();
            if (isValidUser) {
                LOGGER.info((Object)("  UMLS Account at " + umlsUrl + " for user " + user + " has been validated"));
                _validUsers.add(cacheCode);
            } else {
                LOGGER.error((Object)("  UMLS Account at " + umlsUrl + " is not valid for user " + user + " with " + pass));
            }
            boolean bl = isValidUser;
            return bl;
        }
        catch (IOException ioE) {
            LOGGER.error((Object)ioE.getMessage());
            return false;
        }
    }

    static {
        LOGGER = Logger.getLogger((String)"UmlsUserApprover");
        _validUsers = new ArrayList<String>();
    }
}

