/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.assertion.medfacts;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

public class CasIndexer<T extends Annotation> {
    private Logger logger = Logger.getLogger((String)CasIndexer.class.getName());
    private JCas jcas;
    protected Map<Integer, T> mapByAddress;
    protected Type targetType;

    public CasIndexer(JCas jcas, Type targetType) {
        this.jcas = jcas;
        this.targetType = targetType;
        this.initialize();
    }

    public CasIndexer() {
    }

    public void initialize() {
        AnnotationIndex annotationIndex = null;
        annotationIndex = this.targetType == null ? this.jcas.getAnnotationIndex() : this.jcas.getAnnotationIndex(this.targetType);
        this.mapByAddress = new HashMap<Integer, T>();
        for (Annotation annotation : annotationIndex) {
            Integer address = annotation.getAddress();
            Annotation current = annotation;
            this.mapByAddress.put(address, current);
        }
    }

    public Annotation lookupByAddress(int address) {
        return (Annotation)this.mapByAddress.get(address);
    }

    public String convertToDebugOutput(String label, T targetAnnotation) {
        StringWriter sw = new StringWriter();
        PrintWriter p = new PrintWriter(sw);
        if (label == null) {
            label = "";
        }
        p.format("=== \"%s\" BEGIN [%d] ===%n", label, targetAnnotation.getAddress());
        TreeSet<Integer> addressSet = new TreeSet<Integer>();
        if (this.mapByAddress != null) {
            addressSet.addAll(this.mapByAddress.keySet());
        }
        if (!addressSet.isEmpty()) {
            for (Integer currentAddress : addressSet) {
                String highlightIfMatching = currentAddress.equals(targetAnnotation.getAddress()) ? "###" : "";
                p.format("ANNOTATION: address: %d %s%n", currentAddress, highlightIfMatching);
                Annotation currentAnnotation = (Annotation)this.mapByAddress.get(currentAddress);
                if (currentAnnotation == null) {
                    p.println("  annotation IS NULL");
                    continue;
                }
                p.format("  class: %s%n", currentAnnotation.getClass().getName());
                p.format("  value: %s%n", currentAnnotation.toString());
            }
        }
        p.format("=== \"%s\" END [%d] ===%n", label, targetAnnotation.getAddress());
        String output = sw.toString();
        p.close();
        return output;
    }

    public JCas getJcas() {
        return this.jcas;
    }

    public void setJcas(JCas jcas) {
        this.jcas = jcas;
    }
}

