/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.assertion.train;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.apache.ctakes.assertion.eval.AssertionEvaluation;
import org.apache.ctakes.assertion.util.AssertionConst;

public class PolarityCotrainingTests {
    static final String RUN_ID = "fullgrid_";
    protected static final String SHARP_TEST = "/projects/data/assertion/data/preprocessed_data/sharp/test";
    protected static final String I2B2_TEST = "/projects/data/assertion/data/preprocessed_data/i2b2/test";
    protected static final String MIPACQ_TEST = "/projects/data/assertion/data/preprocessed_data/mipacq/test";
    protected static final String NEGEX_TEST = "/projects/data/assertion/data/preprocessed_data/negex";

    public static void main(String[] args) throws Exception {
        AssertionEvaluation.useEvaluationLogFile = true;
        AssertionEvaluation.evaluationLogFilePath = "eval/fullgrid_" + new Date().toString().replaceAll(" ", "_") + ".txt";
        ArrayList<TestPair> testGrid = new ArrayList<TestPair>();
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/sharptrain", SHARP_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/sharptrain", I2B2_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/sharptrain", MIPACQ_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/sharptrain", NEGEX_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/i2b2train", SHARP_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/i2b2train", I2B2_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/i2b2train", MIPACQ_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/i2b2train", NEGEX_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/mipacqtrain", SHARP_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/mipacqtrain", I2B2_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/mipacqtrain", MIPACQ_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/mipacqtrain", NEGEX_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/negextest", SHARP_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/negextest", I2B2_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/negextest", MIPACQ_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/negextest", NEGEX_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/sharptrain+i2b2train", SHARP_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/sharptrain+i2b2train", I2B2_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/sharptrain+i2b2train", MIPACQ_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/sharptrain+i2b2train", NEGEX_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/sharptrain+mipacqtrain", SHARP_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/sharptrain+mipacqtrain", I2B2_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/sharptrain+mipacqtrain", MIPACQ_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/sharptrain+mipacqtrain", NEGEX_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/sharptrain+negextest", SHARP_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/sharptrain+negextest", I2B2_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/sharptrain+negextest", MIPACQ_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/sharptrain+negextest", NEGEX_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/i2b2train+mipacqtrain+negextest", SHARP_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/sharptrain+mipacqtrain+negextest", I2B2_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/sharptrain+i2b2train+negextest", MIPACQ_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/sharptrain+i2b2train+mipacqtrain", SHARP_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/sharptrain+i2b2train+mipacqtrain", I2B2_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/sharptrain+i2b2train+mipacqtrain", MIPACQ_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/sharptrain+i2b2train+mipacqtrain", NEGEX_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/sharpi2b2mipacqnegex", SHARP_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/sharpi2b2mipacqnegex", I2B2_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/sharpi2b2mipacqnegex", MIPACQ_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/sharpi2b2mipacqnegex", NEGEX_TEST));
        String attribute = "polarity";
        for (TestPair oneTest : testGrid) {
            ArrayList<String> params = new ArrayList<String>();
            File instancef = new File("eval/instances_" + oneTest.model.substring(oneTest.model.lastIndexOf("/") + 1) + "_" + oneTest.data.substring(oneTest.data.length() - 13).replaceAll("\\/", "-"));
            params.add("--test-dir");
            params.add(oneTest.data);
            params.add("--models-dir");
            params.add(oneTest.model);
            params.add("--test-only");
            params.add("--print-instances");
            params.add(instancef.getAbsolutePath());
            for (String ignoreAttribute : AssertionConst.allAnnotationTypes) {
                if (ignoreAttribute.equals(attribute)) continue;
                if (ignoreAttribute.equals("historyOf")) {
                    ignoreAttribute = ignoreAttribute.substring(0, ignoreAttribute.length() - 2);
                }
                params.add("--ignore-" + ignoreAttribute);
            }
            String[] paramList = params.toArray(new String[0]);
            System.out.println(Arrays.asList(paramList).toString());
            AssertionEvaluation.main(paramList);
        }
    }

    static class TestPair {
        String model;
        String data;

        TestPair(String a, String b) {
            this.model = a;
            this.data = b;
        }
    }
}

