/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.coreference.eval.helpers;

import org.apache.ctakes.coreference.eval.helpers.SpanOffsetComparator;

public class Span {
    int[][] s;
    int length;

    public Span() {
    }

    public Span(int[] i) {
        if (i.length % 2 == 0) {
            this.length = 0;
            this.s = new int[i.length / 2][2];
            for (int j = 0; j < i.length; j += 2) {
                this.s[j / 2][0] = i[j];
                this.s[j / 2][1] = i[j + 1];
                this.length += i[j + 1] - i[j];
            }
        }
    }

    public Span(String str) {
        String[] ss = str.split("[-:]");
        if (ss.length % 2 == 0) {
            this.s = new int[ss.length / 2][2];
            for (int i = 0; i < ss.length; i += 2) {
                this.s[i / 2][0] = Integer.parseInt(ss[i]);
                this.s[i / 2][1] = Integer.parseInt(ss[i + 1]);
                this.length += this.s[i / 2][1] - this.s[i / 2][0];
            }
        }
    }

    public int size() {
        return this.s.length;
    }

    public int length() {
        return this.length;
    }

    public int[] get(int i) {
        return this.s[i];
    }

    public Span tail() {
        if (this.s.length == 1) {
            return new Span();
        }
        int[] ret = new int[(this.s.length - 1) * 2];
        for (int i = 1; i < this.s.length; ++i) {
            ret[(i - 1) * 2] = this.s[i][0];
            ret[i * 2 - 1] = this.s[i][1];
        }
        return new Span(ret);
    }

    public static double score(Span s1, Span s2) {
        int i;
        double a = 0.0;
        double b = 0.0;
        for (i = 0; i < s1.size(); ++i) {
            for (int j = 0; j < s2.size(); ++j) {
                a += (double)Span.overlap(s1.get(i), s2.get(j));
            }
        }
        for (i = 0; i < s1.size(); ++i) {
            b += (double)(s1.get(i)[1] - s1.get(i)[0]);
        }
        for (i = 0; i < s2.size(); ++i) {
            b += (double)(s2.get(i)[1] - s2.get(i)[0]);
        }
        return a == 0.0 ? -1.0 : a / b;
    }

    private static int overlap(int[] a, int[] b) {
        int ret = a[0] >= b[0] ? (a[1] > b[1] ? b[1] : a[1]) - a[0] : (a[1] < b[1] ? a[1] : b[1]) - b[0];
        if ((ret *= 2) < 0) {
            ret = 0;
        }
        return ret;
    }

    public double gap() {
        return 0.0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int[] i : this.s) {
            sb.append(i[0]).append("-").append(i[1]).append(":");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Span)) {
            return false;
        }
        Span span = (Span)o;
        if (this.size() != span.size()) {
            return false;
        }
        SpanOffsetComparator soc = new SpanOffsetComparator();
        return soc.compare(this, span) == 0;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

