/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.outputchart;

import com.icesoft.faces.component.outputchart.AxisChart;
import com.icesoft.faces.component.outputchart.ChartResource;
import com.icesoft.faces.component.outputchart.ColorMap;
import com.icesoft.faces.component.outputchart.LegendPlacementMap;
import com.icesoft.faces.component.outputchart.OutputChart;
import com.icesoft.faces.component.outputchart.PieChart;
import com.icesoft.faces.component.outputchart.ShapeMap;
import com.icesoft.faces.context.ResourceRegistryLocator;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.krysalis.jcharts.Chart;
import org.krysalis.jcharts.encoders.JPEGEncoder;
import org.krysalis.jcharts.imageMap.ImageMap;
import org.krysalis.jcharts.imageMap.ImageMapArea;
import org.krysalis.jcharts.properties.LegendProperties;
import org.krysalis.jcharts.test.TestDataGenerator;

public abstract class AbstractChart
implements Serializable {
    private final Log log = LogFactory.getLog(AbstractChart.class);
    protected transient Chart chart = null;
    private transient Chart userDefinedChart = null;
    private static ColorMap colorMap = new ColorMap();
    private static ShapeMap shapeMap = new ShapeMap();
    private static LegendPlacementMap legendPlacementMap = new LegendPlacementMap();
    private ImageMapArea clickedImageMapArea;
    private Map generatedImageMapArea = new HashMap();
    Paint[] paintArray = null;

    public AbstractChart() {
    }

    public AbstractChart(UIComponent uiComponent) throws Throwable {
    }

    public void encode(FacesContext context, OutputChart outputChart) throws Throwable {
        String type = outputChart.getType();
        Chart currentChart = this.getChart();
        if (this.chart == currentChart) {
            this.buildChart(outputChart);
        }
        if (this.getChart() != null) {
            if (outputChart.isClientSideImageMap()) {
                this.generateMap(this.getChart());
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            JPEGEncoder.encode((Chart)this.getChart(), (float)1.0f, (OutputStream)bos);
            byte[] data = bos.toByteArray();
            bos.flush();
            bos.close();
            bos = null;
            outputChart.setChartResource(new ChartResource(data));
            outputChart.setChartURI(ResourceRegistryLocator.locate(context).registerResource(outputChart.getChartResource()));
        } else {
            this.log.equals("The jchart is not defined for the " + outputChart.getClientId(FacesContext.getCurrentInstance()) + ", please check if the proper [type] has been defined");
        }
    }

    private void generateMap(Chart chart) throws Throwable {
        chart.renderWithImageMap();
        this.generatedImageMapArea.clear();
        ImageMap imageMap = chart.getImageMap();
        Iterator iterator = imageMap.getIterator();
        while (iterator.hasNext()) {
            ImageMapArea mapArea = (ImageMapArea)iterator.next();
            this.generatedImageMapArea.put(mapArea.hashCode() + "", mapArea);
        }
    }

    protected abstract void buildChart(OutputChart var1) throws Throwable;

    static AbstractChart createChart(UIComponent uiComponent) throws Throwable {
        String type = ((OutputChart)uiComponent).getType();
        if (OutputChart.PIE2D_CHART_TYPE.equalsIgnoreCase(type) || OutputChart.PIE3D_CHART_TYPE.equalsIgnoreCase(type)) {
            return new PieChart(uiComponent);
        }
        return new AxisChart(uiComponent);
    }

    public Chart getChart() {
        if (this.userDefinedChart != null) {
            return this.userDefinedChart;
        }
        return this.chart;
    }

    public void setChart(Chart userDefinedChart) {
        this.userDefinedChart = userDefinedChart;
    }

    public String[] getAsStringArray(Object obj) {
        if (obj instanceof String[]) {
            return (String[])obj;
        }
        if (obj instanceof String) {
            return ((String)obj).split(",");
        }
        if (obj instanceof List) {
            return ((List)obj).toArray(new String[0]);
        }
        return null;
    }

    public double[][] getAs2dDoubleArray(Object obj) {
        Object dbl2DArray;
        block4: {
            block5: {
                block3: {
                    dbl2DArray = null;
                    if (!(obj instanceof double[][])) break block3;
                    dbl2DArray = (double[][])obj;
                    break block4;
                }
                if (!(obj instanceof String)) break block5;
                String[] temp = ((String)obj).split(":");
                dbl2DArray = new double[temp.length][];
                for (int i = 0; i < temp.length; ++i) {
                    dbl2DArray[i] = this.getAsDoubleArray(temp[i]);
                }
                break block4;
            }
            if (!(obj instanceof List)) break block4;
            List list = (List)obj;
            double[] outer = (double[])list.get(0);
            dbl2DArray = new double[outer.length][list.size()];
            for (int j = 0; j < list.size(); ++j) {
                for (int i = 0; i < outer.length; ++i) {
                    outer = (double[])list.get(j);
                    dbl2DArray[i][j] = outer[i];
                }
            }
        }
        return dbl2DArray;
    }

    public double[] getAsDoubleArray(Object obj) {
        double[] dblArray = null;
        if (obj instanceof String) {
            String[] temp = ((String)obj).split(",");
            dblArray = new double[temp.length];
            for (int i = 0; i < temp.length; ++i) {
                dblArray[i] = Double.parseDouble(temp[i]);
            }
        } else if (obj instanceof List) {
            List objList = (List)obj;
            dblArray = new double[objList.size()];
            for (int i = 0; i < objList.size(); ++i) {
                dblArray[i] = (Double)objList.get(i);
            }
        } else if (obj instanceof double[]) {
            dblArray = (double[])obj;
        }
        return dblArray;
    }

    public Paint[] getAsPaintArray(Object obj) {
        block5: {
            block6: {
                block4: {
                    if (!(obj instanceof String)) break block4;
                    if (this.paintArray != null) {
                        return this.paintArray;
                    }
                    String[] temp = ((String)obj).split(",");
                    this.paintArray = new Paint[temp.length];
                    for (int i = 0; i < temp.length; ++i) {
                        this.paintArray[i] = colorMap.getColor(temp[i].trim());
                    }
                    break block5;
                }
                if (!(obj instanceof List)) break block6;
                List objList = (List)obj;
                this.paintArray = new Paint[objList.size()];
                for (int i = 0; i < objList.size(); ++i) {
                    this.paintArray[i] = (Paint)objList.get(i);
                }
                break block5;
            }
            if (!(obj instanceof String[])) break block5;
            String[] colors = (String[])obj;
            this.paintArray = new Paint[colors.length];
            for (int i = 0; i < colors.length; ++i) {
                this.paintArray[i] = colorMap.getColor(colors[i]);
            }
        }
        return this.paintArray;
    }

    public Shape[] getAsShapeArray(Object obj) {
        Shape[] shapeArray;
        block3: {
            block2: {
                shapeArray = null;
                if (!(obj instanceof String)) break block2;
                String[] temp = ((String)obj).split(",");
                shapeArray = new Shape[temp.length];
                for (int i = 0; i < temp.length; ++i) {
                    shapeArray[i] = shapeMap.getShape(temp[i].trim());
                }
                break block3;
            }
            if (!(obj instanceof List)) break block3;
            List objList = (List)obj;
            shapeArray = new Shape[objList.size()];
            for (int i = 0; i < objList.size(); ++i) {
                shapeArray[i] = (Shape)objList.get(i);
            }
        }
        return shapeArray;
    }

    Shape[] getGeneratedShapes(int count) {
        Shape[] tempShapeArray = new Shape[count];
        Iterator it = shapeMap.values().iterator();
        for (int i = 0; i < count; ++i) {
            if (it.hasNext()) {
                tempShapeArray[i] = (Shape)it.next();
                continue;
            }
            it = shapeMap.values().iterator();
            tempShapeArray[i] = (Shape)it.next();
        }
        return tempShapeArray;
    }

    String[] getGeneratedLabels(String label, int count) {
        String[] tempStringArray = new String[count];
        for (int i = 0; i < count; ++i) {
            tempStringArray[i] = label + " " + i;
        }
        return tempStringArray;
    }

    public Paint[] getPaints(Object obj, int count) {
        if (obj == null && this.paintArray == null) {
            this.paintArray = TestDataGenerator.getRandomPaints((int)count);
            return this.paintArray;
        }
        if (obj == null && this.paintArray != null) {
            return this.paintArray;
        }
        if (this.paintArray != null && this.paintArray.length != count) {
            this.paintArray = null;
        }
        return this.getAsPaintArray(obj);
    }

    public Map getGeneratedImageMapArea() {
        return this.generatedImageMapArea;
    }

    public ImageMapArea getClickedImageMapArea() {
        return this.clickedImageMapArea;
    }

    public void setClickedImageMapArea(ImageMapArea clickedImageMapArea) {
        this.clickedImageMapArea = clickedImageMapArea;
    }

    public static Color getColor(String color) {
        return colorMap.getColor(color);
    }

    public LegendProperties getLegendProperties(OutputChart outputChart) {
        String legendPlacement = (String)outputChart.getLegendPlacement();
        if (legendPlacement.equals("none")) {
            return null;
        }
        LegendProperties legendProperties = new LegendProperties();
        legendProperties.setPlacement(legendPlacementMap.getLegendPlacement(legendPlacement));
        Object legendColumns = outputChart.getLegendColumns();
        if (legendColumns instanceof Integer) {
            legendProperties.setNumColumns(((Integer)outputChart.getLegendColumns()).intValue());
        } else if (legendColumns instanceof String) {
            legendProperties.setNumColumns(Integer.parseInt(outputChart.getLegendColumns().toString()));
        }
        return legendProperties;
    }
}

