/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.timeml.tlink;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.feature.FilteringExtractor;
import org.cleartk.ml.feature.extractor.CleartkExtractor;
import org.cleartk.ml.feature.extractor.CoveredTextExtractor;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;
import org.cleartk.ml.feature.extractor.TypePathExtractor;
import org.cleartk.ml.liblinear.LibLinearStringOutcomeDataWriter;
import org.cleartk.syntax.constituent.type.TreebankNode;
import org.cleartk.syntax.constituent.type.TreebankNodeUtil;
import org.cleartk.timeml.tlink.TemporalLinkAnnotator_ImplBase;
import org.cleartk.timeml.type.Anchor;
import org.cleartk.timeml.type.Event;
import org.cleartk.timeml.type.Time;
import org.cleartk.timeml.util.CleartkInternalModelFactory;
import org.cleartk.token.type.Sentence;
import org.cleartk.token.type.Token;

public class TemporalLinkEventToSameSentenceTimeAnnotator
extends TemporalLinkAnnotator_ImplBase<Event, Time> {
    public static final CleartkInternalModelFactory FACTORY = new CleartkInternalModelFactory(){

        @Override
        public Class<?> getAnnotatorClass() {
            return TemporalLinkEventToSameSentenceTimeAnnotator.class;
        }

        @Override
        public Class<?> getDataWriterClass() {
            return LibLinearStringOutcomeDataWriter.class;
        }

        @Override
        public AnalysisEngineDescription getBaseDescription() throws ResourceInitializationException {
            return AnalysisEngineFactory.createEngineDescription(TemporalLinkEventToSameSentenceTimeAnnotator.class, (Object[])new Object[0]);
        }
    };
    private static final Pattern SUBORDINATE_PATH_PATTERN = Pattern.compile("^((NP|PP|ADVP)>)*((VP|SBAR|S)>)*(S|SBAR|VP|NP)(<(VP|SBAR|S))*(<(NP|PP|ADVP))*$");

    public TemporalLinkEventToSameSentenceTimeAnnotator() {
        super(Event.class, Time.class, "INCLUDES", "IS_INCLUDED");
    }

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        FilteringExtractor<Token> prepOrVerbExtractor = new FilteringExtractor<Token>(Token.class, (FeatureExtractor1)new CoveredTextExtractor()){

            protected boolean accept(Token token) {
                return token.getPos().equals("TO") || token.getPos().equals("IN") || token.getPos().startsWith("VB");
            }
        };
        ArrayList srcExtractors = Lists.newArrayList();
        srcExtractors.add(new TypePathExtractor(Event.class, "tense"));
        srcExtractors.add(new TypePathExtractor(Event.class, "eventClass"));
        srcExtractors.add(new CleartkExtractor(Token.class, (FeatureExtractor1)prepOrVerbExtractor, new CleartkExtractor.Context[]{new CleartkExtractor.Ngram(new CleartkExtractor.Context[]{new CleartkExtractor.Following(5)})}));
        this.setSourceExtractors(srcExtractors);
        ArrayList tgtExtractors = Lists.newArrayList();
        tgtExtractors.add(new CleartkExtractor(Token.class, (FeatureExtractor1)new CoveredTextExtractor(), new CleartkExtractor.Context[]{new CleartkExtractor.Bag(new CleartkExtractor.Context[]{new CleartkExtractor.Covered()})}));
        tgtExtractors.add(new TypePathExtractor(Time.class, "timeType"));
        tgtExtractors.add(new TypePathExtractor(Time.class, "value"));
        tgtExtractors.add(new CleartkExtractor(Token.class, (FeatureExtractor1)prepOrVerbExtractor, new CleartkExtractor.Context[]{new CleartkExtractor.Ngram(new CleartkExtractor.Context[]{new CleartkExtractor.Preceding(5)})}));
        this.setTargetExtractors(tgtExtractors);
        ArrayList btweenExtractors = Lists.newArrayList();
        btweenExtractors.add(new CleartkExtractor(Token.class, (FeatureExtractor1)prepOrVerbExtractor, new CleartkExtractor.Context[]{new CleartkExtractor.Bag(new CleartkExtractor.Context[]{new CleartkExtractor.Covered()})}));
    }

    @Override
    protected List<TemporalLinkAnnotator_ImplBase.SourceTargetPair> getSourceTargetPairs(JCas jCas) {
        ArrayList pairs = Lists.newArrayList();
        for (Sentence sentence : JCasUtil.select((JCas)jCas, Sentence.class)) {
            for (Event event : JCasUtil.selectCovered((JCas)jCas, Event.class, (AnnotationFS)sentence)) {
                for (Time time : TemporalLinkEventToSameSentenceTimeAnnotator.getSubordinateTimes(event, sentence, jCas)) {
                    pairs.add(new TemporalLinkAnnotator_ImplBase.SourceTargetPair((TemporalLinkAnnotator_ImplBase)this, (Anchor)event, (Anchor)time));
                }
            }
        }
        return pairs;
    }

    private static List<Time> getSubordinateTimes(Event event, Sentence sentence, JCas jCas) {
        ArrayList<Time> times = new ArrayList<Time>();
        TreebankNode eventNode = TreebankNodeUtil.selectMatchingLeaf((JCas)jCas, (Annotation)event);
        for (Time time : JCasUtil.selectCovered((JCas)jCas, Time.class, (AnnotationFS)sentence)) {
            String path;
            TreebankNode timeNode = TreebankNodeUtil.selectHighestCoveredTreebankNode((JCas)jCas, (Annotation)time);
            if (eventNode == null || timeNode == null || !SUBORDINATE_PATH_PATTERN.matcher(path = TemporalLinkEventToSameSentenceTimeAnnotator.noLeavesPath(TreebankNodeUtil.getPath((TreebankNode)eventNode, (TreebankNode)timeNode))).matches()) continue;
            times.add(time);
        }
        return times;
    }
}

