/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.NormsFormat;
import org.apache.lucene.codecs.PerDocConsumer;
import org.apache.lucene.index.DocInverterPerField;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocumentsWriterPerThread;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.InvertedDocEndConsumer;
import org.apache.lucene.index.InvertedDocEndConsumerPerField;
import org.apache.lucene.index.NormsConsumerPerField;
import org.apache.lucene.index.PerDocWriteState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.util.IOUtils;

final class NormsConsumer
extends InvertedDocEndConsumer {
    private final NormsFormat normsFormat;
    private PerDocConsumer consumer;

    public NormsConsumer(DocumentsWriterPerThread dwpt) {
        this.normsFormat = dwpt.codec.normsFormat();
    }

    @Override
    public void abort() {
        if (this.consumer != null) {
            this.consumer.abort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(Map<String, InvertedDocEndConsumerPerField> fieldsToFlush, SegmentWriteState state) throws IOException {
        block11: {
            block10: {
                boolean success = false;
                boolean anythingFlushed = false;
                try {
                    if (state.fieldInfos.hasNorms()) {
                        for (FieldInfo fi : state.fieldInfos) {
                            NormsConsumerPerField toWrite = (NormsConsumerPerField)fieldsToFlush.get(fi.name);
                            if (fi.omitsNorms()) continue;
                            if (toWrite != null && toWrite.initialized()) {
                                anythingFlushed = true;
                                DocValues.Type type = toWrite.flush(state.segmentInfo.getDocCount());
                                assert (fi.getNormType() == type);
                                continue;
                            }
                            if (!fi.isIndexed()) continue;
                            anythingFlushed = true;
                            assert (fi.getNormType() == null) : "got " + (Object)((Object)fi.getNormType()) + "; field=" + fi.name;
                        }
                    }
                    success = true;
                    if (!anythingFlushed && this.consumer != null) {
                        this.consumer.abort();
                    }
                    if (!success) break block10;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(this.consumer);
                    } else {
                        IOUtils.closeWhileHandlingException(this.consumer);
                    }
                    throw throwable;
                }
                IOUtils.close(this.consumer);
                break block11;
            }
            IOUtils.closeWhileHandlingException(this.consumer);
        }
    }

    @Override
    void finishDocument() {
    }

    @Override
    void startDocument() {
    }

    @Override
    InvertedDocEndConsumerPerField addField(DocInverterPerField docInverterPerField, FieldInfo fieldInfo) {
        return new NormsConsumerPerField(docInverterPerField, fieldInfo, this);
    }

    DocValuesConsumer newConsumer(PerDocWriteState perDocWriteState, FieldInfo fieldInfo, DocValues.Type type) throws IOException {
        if (this.consumer == null) {
            this.consumer = this.normsFormat.docsConsumer(perDocWriteState);
        }
        DocValuesConsumer addValuesField = this.consumer.addValuesField(type, fieldInfo);
        return addValuesField;
    }
}

