/*
 * Decompiled with CFR 0.152.
 */
package com.sun.istack.tools;

import com.sun.istack.tools.SecureLoader;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DynamicConfigurator;
import org.apache.tools.ant.IntrospectionHelper;
import org.apache.tools.ant.Task;

public abstract class ProtectedTask
extends Task
implements DynamicConfigurator {
    private final AntElement root = new AntElement("root");

    public void setDynamicAttribute(String name, String value) throws BuildException {
        this.root.setDynamicAttribute(name, value);
    }

    public Object createDynamicElement(String name) throws BuildException {
        return this.root.createDynamicElement(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        ClassLoader cl;
        ClassLoader ccl = SecureLoader.getContextClassLoader();
        try {
            cl = this.createClassLoader();
            Class<?> driver = cl.loadClass(this.getCoreClassName());
            Task t = (Task)driver.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            t.setProject(this.getProject());
            t.setTaskName(this.getTaskName());
            this.root.configure(t);
            SecureLoader.setContextClassLoader(cl);
            try {
                t.execute();
            }
            finally {
                driver = null;
                t.setTaskName(null);
                t.setProject(null);
                t = null;
            }
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (UnsupportedClassVersionError e) {
            try {
                throw new BuildException("Requires Java SE 8 or later. Please download it from https://www.oracle.com/java/technologies/javase-download.html");
                catch (IOException | ReflectiveOperationException e2) {
                    throw new BuildException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                ClassLoader cl2 = Thread.currentThread().getContextClassLoader();
                SecureLoader.setContextClassLoader(ccl);
                while (cl2 != null && !ccl.equals(cl2)) {
                    if (cl2 instanceof Closeable) {
                        try {
                            ((Closeable)((Object)cl2)).close();
                        }
                        catch (IOException ex) {
                            throw new BuildException((Throwable)ex);
                        }
                    }
                    if (cl2 instanceof URLClassLoader) {
                        try {
                            Class<?> clUtil = ccl.loadClass("sun.misc.ClassLoaderUtil");
                            Method release = clUtil.getDeclaredMethod("releaseLoader", URLClassLoader.class);
                            release.invoke(null, cl2);
                        }
                        catch (ClassNotFoundException clUtil) {
                        }
                        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException ex) {
                            throw new BuildException((Throwable)ex);
                        }
                    }
                    cl2 = this.getParentClassLoader(cl2);
                }
                cl2 = null;
                throw throwable;
            }
        }
        SecureLoader.setContextClassLoader(ccl);
        while (cl != null) {
            if (ccl.equals(cl)) return;
            if (cl instanceof Closeable) {
                try {
                    ((Closeable)((Object)cl)).close();
                }
                catch (IOException ex) {
                    throw new BuildException((Throwable)ex);
                }
            }
            if (cl instanceof URLClassLoader) {
                try {
                    Class<?> clUtil = ccl.loadClass("sun.misc.ClassLoaderUtil");
                    Method release = clUtil.getDeclaredMethod("releaseLoader", URLClassLoader.class);
                    release.invoke(null, cl);
                }
                catch (ClassNotFoundException clUtil) {
                }
                catch (IllegalArgumentException | ReflectiveOperationException | SecurityException ex) {
                    throw new BuildException((Throwable)ex);
                }
            }
            cl = this.getParentClassLoader(cl);
        }
    }

    protected abstract String getCoreClassName();

    protected abstract ClassLoader createClassLoader() throws ClassNotFoundException, IOException;

    private ClassLoader getParentClassLoader(ClassLoader cl) {
        if (cl instanceof AntClassLoader) {
            ClassLoader loader = ((AntClassLoader)cl).getConfiguredParent();
            return loader == null ? null : (loader.getClass().getName().startsWith("org.gradle.") ? null : loader);
        }
        return SecureLoader.getParentClassLoader(cl);
    }

    private class AntElement
    implements DynamicConfigurator {
        private final String name;
        private final Map<String, String> attributes = new HashMap<String, String>();
        private final List<AntElement> elements = new ArrayList<AntElement>();

        public AntElement(String name) {
            this.name = name;
        }

        public void setDynamicAttribute(String name, String value) throws BuildException {
            this.attributes.put(name, value);
        }

        public Object createDynamicElement(String name) throws BuildException {
            AntElement e = new AntElement(name);
            this.elements.add(e);
            return e;
        }

        public void configure(Object antObject) {
            IntrospectionHelper ih = IntrospectionHelper.getHelper(antObject.getClass());
            for (Map.Entry<String, String> att : this.attributes.entrySet()) {
                ih.setAttribute(ProtectedTask.this.getProject(), antObject, att.getKey(), att.getValue());
            }
            for (AntElement e : this.elements) {
                Object child = ih.getElementCreator(ProtectedTask.this.getProject(), "", antObject, e.name, null).create();
                e.configure(child);
                ih.storeElement(ProtectedTask.this.getProject(), antObject, child, e.name);
            }
        }
    }
}

