/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.theta;

import org.apache.datasketches.hive.theta.EstimateSketchSimilarityUDF;
import org.apache.datasketches.theta.Sketches;
import org.apache.datasketches.theta.UpdateSketch;
import org.apache.hadoop.io.BytesWritable;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class EstimateSketchSimilarityUDFTest {
    @Test
    public void evaluateNull() {
        EstimateSketchSimilarityUDF testObject = new EstimateSketchSimilarityUDF();
        double testResult = testObject.evaluate(null, null);
        AssertJUnit.assertEquals((Object)0.0, (Object)testResult);
    }

    @Test
    public void evaluateEmpty() {
        EstimateSketchSimilarityUDF testObject = new EstimateSketchSimilarityUDF();
        double testResult = testObject.evaluate(new BytesWritable(), new BytesWritable());
        AssertJUnit.assertEquals((Object)0.0, (Object)testResult);
    }

    @Test
    public void evaluateValidSketch() {
        EstimateSketchSimilarityUDF testObject = new EstimateSketchSimilarityUDF();
        UpdateSketch sketch1 = Sketches.updateSketchBuilder().setNominalEntries(1024).build();
        for (int i = 0; i < 128; ++i) {
            sketch1.update((long)i);
        }
        UpdateSketch sketch2 = Sketches.updateSketchBuilder().setNominalEntries(1024).build();
        for (int i = 100; i < 128; ++i) {
            sketch2.update((long)i);
        }
        BytesWritable input1 = new BytesWritable(sketch1.compact().toByteArray());
        BytesWritable input2 = new BytesWritable(sketch2.compact().toByteArray());
        double result = testObject.evaluate(input1, input2);
        AssertJUnit.assertEquals((Object)0.21875, (Object)result);
    }
}

