/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.tuple;

import java.util.Arrays;
import java.util.List;
import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.hive.tuple.DataToDoubleSummarySketchUDAF;
import org.apache.datasketches.hive.tuple.State;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.Sketches;
import org.apache.datasketches.tuple.SummaryDeserializer;
import org.apache.datasketches.tuple.SummaryFactory;
import org.apache.datasketches.tuple.UpdatableSketch;
import org.apache.datasketches.tuple.UpdatableSketchBuilder;
import org.apache.datasketches.tuple.adouble.DoubleSummary;
import org.apache.datasketches.tuple.adouble.DoubleSummaryDeserializer;
import org.apache.datasketches.tuple.adouble.DoubleSummaryFactory;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFParameterInfo;
import org.apache.hadoop.hive.ql.udf.generic.SimpleGenericUDAFParameterInfo;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DataToDoubleSummarySketchUDAFTest {
    private static final ObjectInspector intInspector = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.INT);
    private static final ObjectInspector doubleInspector = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.DOUBLE);
    private static final ObjectInspector stringInspector = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.STRING);
    private static final ObjectInspector floatInspector = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.FLOAT);
    private static final ObjectInspector binaryInspector = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.BINARY);
    private static final ObjectInspector structInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList("nominalEntries", "sketch"), Arrays.asList(intInspector, binaryInspector));

    @Test(expectedExceptions={UDFArgumentException.class})
    public void tooFewArguments() throws SemanticException {
        ObjectInspector[] inspectors = new ObjectInspector[]{intInspector};
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new DataToDoubleSummarySketchUDAF().getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test(expectedExceptions={UDFArgumentException.class})
    public void tooManyArguments() throws SemanticException {
        ObjectInspector[] inspectors = new ObjectInspector[]{intInspector, doubleInspector, intInspector, floatInspector, intInspector};
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new DataToDoubleSummarySketchUDAF().getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void invalidCategoryArg1() throws SemanticException {
        ObjectInspector[] inspectors = new ObjectInspector[]{structInspector, doubleInspector};
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new DataToDoubleSummarySketchUDAF().getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test(expectedExceptions={UDFArgumentException.class})
    public void invalidCategoryArg2() throws SemanticException {
        ObjectInspector[] inspectors = new ObjectInspector[]{intInspector, structInspector};
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new DataToDoubleSummarySketchUDAF().getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test(expectedExceptions={UDFArgumentException.class})
    public void invalidTypeArg2() throws SemanticException {
        ObjectInspector[] inspectors = new ObjectInspector[]{intInspector, intInspector};
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new DataToDoubleSummarySketchUDAF().getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void invalidCategoryArg3() throws SemanticException {
        ObjectInspector[] inspectors = new ObjectInspector[]{intInspector, doubleInspector, structInspector};
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new DataToDoubleSummarySketchUDAF().getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void invalidTypeArg3() throws SemanticException {
        ObjectInspector[] inspectors = new ObjectInspector[]{intInspector, doubleInspector, doubleInspector};
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new DataToDoubleSummarySketchUDAF().getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void invalidCategoryArg4() throws SemanticException {
        ObjectInspector[] inspectors = new ObjectInspector[]{intInspector, doubleInspector, intInspector, structInspector};
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new DataToDoubleSummarySketchUDAF().getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void invalidTypeArg4() throws SemanticException {
        ObjectInspector[] inspectors = new ObjectInspector[]{intInspector, doubleInspector, intInspector, intInspector};
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new DataToDoubleSummarySketchUDAF().getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test
    public void partial1ModeIntKeysDefaultParams() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{intInspector, doubleInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new DataToDoubleSummarySketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.PARTIAL1, inspectors);
            DataToDoubleSummarySketchUDAFTest.checkIntermediateResultInspector(resultInspector);
            State state = (State)eval.getNewAggregationBuffer();
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new IntWritable(1), new DoubleWritable(1.0)});
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new IntWritable(2), new DoubleWritable(1.0)});
            Object result = eval.terminatePartial((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)(result instanceof List));
            List r = (List)result;
            Assert.assertEquals((int)r.size(), (int)2);
            Assert.assertEquals((int)((IntWritable)r.get(0)).get(), (int)4096);
            Sketch resultSketch = Sketches.heapifySketch((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)((BytesWritable)r.get(1))), (SummaryDeserializer)new DoubleSummaryDeserializer());
            Assert.assertFalse((boolean)resultSketch.isEstimationMode());
            Assert.assertEquals((double)resultSketch.getEstimate(), (double)2.0);
        }
    }

    @Test
    public void partial1ModeStringKeysExplicitParams() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{stringInspector, doubleInspector, intInspector, floatInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new DataToDoubleSummarySketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.PARTIAL1, inspectors);
            DataToDoubleSummarySketchUDAFTest.checkIntermediateResultInspector(resultInspector);
            State state = (State)eval.getNewAggregationBuffer();
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new Text("a"), new DoubleWritable(1.0), new IntWritable(32), new FloatWritable(0.99f)});
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new Text("b"), new DoubleWritable(1.0), new IntWritable(32), new FloatWritable(0.99f)});
            Object result = eval.terminatePartial((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)(result instanceof List));
            List r = (List)result;
            Assert.assertEquals((int)r.size(), (int)2);
            Assert.assertEquals((int)((IntWritable)r.get(0)).get(), (int)32);
            Sketch resultSketch = Sketches.heapifySketch((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)((BytesWritable)r.get(1))), (SummaryDeserializer)new DoubleSummaryDeserializer());
            Assert.assertTrue((boolean)resultSketch.isEstimationMode());
            Assert.assertEquals((double)resultSketch.getEstimate(), (double)2.0, (double)0.05);
        }
    }

    @Test
    public void partial2Mode() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{intInspector, doubleInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new DataToDoubleSummarySketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.PARTIAL2, new ObjectInspector[]{structInspector});
            DataToDoubleSummarySketchUDAFTest.checkIntermediateResultInspector(resultInspector);
            State state = (State)eval.getNewAggregationBuffer();
            UpdatableSketch sketch1 = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(DoubleSummary.Mode.Sum)).build();
            sketch1.update(1L, (Object)1.0);
            eval.merge((GenericUDAFEvaluator.AggregationBuffer)state, Arrays.asList(new IntWritable(4096), new BytesWritable(sketch1.compact().toByteArray())));
            UpdatableSketch sketch2 = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(DoubleSummary.Mode.Sum)).build();
            sketch2.update(2L, (Object)1.0);
            eval.merge((GenericUDAFEvaluator.AggregationBuffer)state, Arrays.asList(new IntWritable(4096), new BytesWritable(sketch2.compact().toByteArray())));
            Object result = eval.terminatePartial((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)(result instanceof List));
            List r = (List)result;
            Assert.assertEquals((int)r.size(), (int)2);
            Assert.assertEquals((int)((IntWritable)r.get(0)).get(), (int)4096);
            Sketch resultSketch = Sketches.heapifySketch((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)((BytesWritable)r.get(1))), (SummaryDeserializer)new DoubleSummaryDeserializer());
            Assert.assertEquals((double)resultSketch.getEstimate(), (double)2.0);
            eval.reset((GenericUDAFEvaluator.AggregationBuffer)state);
            result = eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNull((Object)result);
        }
    }

    @Test
    public void finalMode() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{intInspector, doubleInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new DataToDoubleSummarySketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.FINAL, new ObjectInspector[]{structInspector});
            DataToDoubleSummarySketchUDAFTest.checkFinalResultInspector(resultInspector);
            State state = (State)eval.getNewAggregationBuffer();
            UpdatableSketch sketch1 = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(DoubleSummary.Mode.Sum)).build();
            sketch1.update(1L, (Object)1.0);
            eval.merge((GenericUDAFEvaluator.AggregationBuffer)state, Arrays.asList(new IntWritable(4096), new BytesWritable(sketch1.compact().toByteArray())));
            UpdatableSketch sketch2 = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(DoubleSummary.Mode.Sum)).build();
            sketch2.update(2L, (Object)1.0);
            eval.merge((GenericUDAFEvaluator.AggregationBuffer)state, Arrays.asList(new IntWritable(4096), new BytesWritable(sketch2.compact().toByteArray())));
            Object result = eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)(result instanceof BytesWritable));
            Sketch resultSketch = Sketches.heapifySketch((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)((BytesWritable)result)), (SummaryDeserializer)new DoubleSummaryDeserializer());
            Assert.assertEquals((double)resultSketch.getEstimate(), (double)2.0);
        }
    }

    @Test
    public void completeModeIntKeysDefaultParams() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{intInspector, doubleInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new DataToDoubleSummarySketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.COMPLETE, inspectors);
            DataToDoubleSummarySketchUDAFTest.checkFinalResultInspector(resultInspector);
            State state = (State)eval.getNewAggregationBuffer();
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new IntWritable(1), new DoubleWritable(1.0)});
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new IntWritable(2), new DoubleWritable(1.0)});
            Object result = eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)(result instanceof BytesWritable));
            Sketch resultSketch = Sketches.heapifySketch((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)((BytesWritable)result)), (SummaryDeserializer)new DoubleSummaryDeserializer());
            Assert.assertEquals((double)resultSketch.getEstimate(), (double)2.0);
            eval.reset((GenericUDAFEvaluator.AggregationBuffer)state);
            result = eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNull((Object)result);
        }
    }

    @Test
    public void completeModeDoubleKeysExplicitParams() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{doubleInspector, doubleInspector, intInspector, floatInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new DataToDoubleSummarySketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.COMPLETE, inspectors);
            DataToDoubleSummarySketchUDAFTest.checkFinalResultInspector(resultInspector);
            State state = (State)eval.getNewAggregationBuffer();
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new DoubleWritable(1.0), new DoubleWritable(1.0), new IntWritable(32), new FloatWritable(0.99f)});
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new DoubleWritable(2.0), new DoubleWritable(1.0), new IntWritable(32), new FloatWritable(0.99f)});
            Object result = eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)(result instanceof BytesWritable));
            Sketch resultSketch = Sketches.heapifySketch((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)((BytesWritable)result)), (SummaryDeserializer)new DoubleSummaryDeserializer());
            Assert.assertTrue((boolean)resultSketch.isEstimationMode());
            Assert.assertEquals((double)resultSketch.getEstimate(), (double)2.0, (double)0.05);
            eval.reset((GenericUDAFEvaluator.AggregationBuffer)state);
            result = eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNull((Object)result);
        }
    }

    @Test
    public void completeModeCheckTrimmingToNominal() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{intInspector, doubleInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new DataToDoubleSummarySketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.COMPLETE, inspectors);
            DataToDoubleSummarySketchUDAFTest.checkFinalResultInspector(resultInspector);
            State state = (State)eval.getNewAggregationBuffer();
            for (int i = 0; i < 10000; ++i) {
                eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new IntWritable(i), new DoubleWritable(1.0)});
            }
            Object result = eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)(result instanceof BytesWritable));
            Sketch resultSketch = Sketches.heapifySketch((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)((BytesWritable)result)), (SummaryDeserializer)new DoubleSummaryDeserializer());
            Assert.assertEquals((double)resultSketch.getEstimate(), (double)10000.0, (double)300.0);
            Assert.assertTrue((resultSketch.getRetainedEntries() <= 4096 ? 1 : 0) != 0, (String)("retained entries: " + resultSketch.getRetainedEntries()));
            eval.reset((GenericUDAFEvaluator.AggregationBuffer)state);
            result = eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNull((Object)result);
        }
    }

    static void checkIntermediateResultInspector(ObjectInspector resultInspector) {
        Assert.assertNotNull((Object)resultInspector);
        Assert.assertEquals((Object)resultInspector.getCategory(), (Object)ObjectInspector.Category.STRUCT);
        StructObjectInspector structResultInspector = (StructObjectInspector)resultInspector;
        List fields = structResultInspector.getAllStructFieldRefs();
        Assert.assertEquals((int)fields.size(), (int)2);
        ObjectInspector inspector1 = ((StructField)fields.get(0)).getFieldObjectInspector();
        Assert.assertEquals((Object)inspector1.getCategory(), (Object)ObjectInspector.Category.PRIMITIVE);
        PrimitiveObjectInspector primitiveInspector1 = (PrimitiveObjectInspector)inspector1;
        Assert.assertEquals((Object)primitiveInspector1.getPrimitiveCategory(), (Object)PrimitiveObjectInspector.PrimitiveCategory.INT);
        ObjectInspector inspector2 = ((StructField)fields.get(1)).getFieldObjectInspector();
        Assert.assertEquals((Object)inspector2.getCategory(), (Object)ObjectInspector.Category.PRIMITIVE);
        PrimitiveObjectInspector primitiveInspector2 = (PrimitiveObjectInspector)inspector2;
        Assert.assertEquals((Object)primitiveInspector2.getPrimitiveCategory(), (Object)PrimitiveObjectInspector.PrimitiveCategory.BINARY);
    }

    static void checkFinalResultInspector(ObjectInspector resultInspector) {
        Assert.assertNotNull((Object)resultInspector);
        Assert.assertEquals((Object)resultInspector.getCategory(), (Object)ObjectInspector.Category.PRIMITIVE);
        Assert.assertEquals((Object)((PrimitiveObjectInspector)resultInspector).getPrimitiveCategory(), (Object)PrimitiveObjectInspector.PrimitiveCategory.BINARY);
    }
}

